(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     98017,       3015]*)
(*NotebookOutlinePosition[     98653,       3037]*)
(*  CellTagsIndexPosition[     98609,       3033]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Nonequispaced Fourier Transform", "Title"],

Cell["\<\
Sseziwa Mukasa,
Software Engineer
JEOL USA
mukasa@jeol.com\
\>", "Text"],

Cell[CellGroupData[{

Cell["Problem Description", "Section"],

Cell["The nonequispaced Fourier transform solves the sum", "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`f\_j = \(f(\[Nu]\_j) = \[Sum]\+\(k \[Element] \
I\_N\%d\)\(f\&^\_k\) \[ExponentialE]\^\(\(-2\)\ \[Pi]\ i\ k\ \
\[Nu]\_j\)\)\)]],
  " (j\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`I\_M\%1\)]],
  ")"
}], "Text",
  TextAlignment->Center],

Cell["or its transpose", "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`h\&^\_k = \[Sum]\+\(j \[Element] I\_M\%1\)f\_j\ \
\[ExponentialE]\^\(2\ \[Pi]i\ k\ \[Nu]\_j\)\)],
    TextAlignment->Center],
  " (k\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`I\_N\%d\)]],
  ")"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j\)]],
  "are M d-dimensional frequencies with ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\/2 \[LessEqual] \[Nu]\_j < 1\/2\)]],
  "for each component of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`I\_N\%d = {k \[Element] \[DoubleStruckCapitalZ]\^d; \
\(-\(N\/2\)\) \[LessEqual] k < N\/2}\)]],
  ".  For ",
  Cell[BoxData[
      \(TraditionalForm\`N\^d\)]],
  " = M, and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j = \(j\/N\) \((j \[Element] I\_N\%d)\)\)]],
  " the first sum is equivalent to the discrete Fourier transform.  For \
arbitrary ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j\)]],
  ", algorithms for approximating the sums to accuracy \[CurlyEpsilon] in ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalO](\(N\^d\) 
            logN + \(\(log\^d\)(1\/\[CurlyEpsilon])\)\ M)\)]],
  " time are given in [1].  This notebook demonstrates the use of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package nfft.m which implements both the direct and approximate methods \
of solving the two sums.  The approximate methods will hereafter be refered \
to as nfft and nfftTransposed for the first and second sums respectively."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NFFT", "Section"],

Cell[TextData[{
  "The functions nfft and nfftTranspose are contained in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package file nfft.m which should be placed in the appropriate location \
for your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " environment."
}], "Text"],

Cell[BoxData[
    \(<< nfft`\)], "Input"],

Cell["\<\
One application of the nfft if is for solving Fourier like sums \
which occur in the Filter Diagonalization Method [2].  Each of the diagonal \
entries of the evolution matrices in the Filter Diagonalization method is a \
sum of the form:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[Sum]\+\(\(n\& \[RightVector] \) = \(0\& \
\[RightVector] \)\)\%\(2\ \(M\& \[RightVector] \)\)\[ExponentialE]\^\(i\ \
\(n\& \[RightVector] \) . \(\[CurlyPhi]\& \[RightVector] \)\)\ \(c(\(n\& \
\[RightVector] \) + \(p\& \[RightVector] \))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "where c is a regularly sampled d-dimensional data set and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\&\[RightVector]\)]],
  " is a basis point in a d-dimensional space with ",
  StyleBox["-\[Pi] \[LessEqual] \[CurlyPhi] < \[Pi]", "InlineFormula"],
  " componentwise.  Letting ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu] = \[CurlyPhi]\/\(2\ \[Pi]\)\)]],
  " and padding c with zeroes to the length 4 ",
  Cell[BoxData[
      \(TraditionalForm\`M\&\[RightVector] + 1\)]],
  " so the sum can be taken over ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-M\&\[RightVector]\), M\&\[RightVector]]\)\)]],
  " then the sum is of the form of a nonequispaced Fourier transform assuming \
the basis functions do not form a regular lattice, in which case a regular \
fast Fourier transform can be employed.  As a concrete example the diagonal \
elements of a random 8x8 data set at the four basis points (-\[Pi],-\[Pi]), \
(-\[Pi],0), ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Pi]\/2, \(-\[Pi]\))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Pi]\/2, 0)\)\)]],
  " can be computed as follows:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Nu] = {{\(-0.5\), \(-0.5\)}, {\(-0.5\), 
            0}, {0.25, \(-0.5\)}, {0.25, 0}};\)\), "\n", 
    \(\(c = PadLeft[Table[Random[], {7}, {7}], {13, 13}];\)\), "\n", 
    \(result = nfft[c, \[Nu]]\)}], "Input"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(Power :: \\\"infy\\\"\\) will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(\[Infinity] :: \\\"indet\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \({\(\(1.3348000490369571`\)\(\[InvisibleSpace]\)\) - 
        3.444436178992068`*^-13\ \[ImaginaryI], \(\(2.0199530152847025`\)\(\
\[InvisibleSpace]\)\) + 
        9.726892239109032`*^-12\ \[ImaginaryI], \(-0.29896244409655753`\) + 
        0.031322510892449584`\ \[ImaginaryI], \(-1.8118249307316765`\) - 
        2.1872668449132893`\ \[ImaginaryI]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The messages are due to singularities in the default window function and \
can be safely ignored, window functions will be described in greater detail \
later.  It should be emphasized that nfft is an approximation, which can be \
compared with a direct calculation of the sum ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k \[Element] I\_N\%d\)\(f\&^\_k\) \
\[ExponentialE]\^\(\(-2\)\ \[Pi]\ i\ k\ \[Nu]\_j\)\)]],
  " (j\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`I\_M\%1\)]],
  ") by using the routine ndft.  For example"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = result - ndft[c, \[Nu]]}, Sqrt[x . Conjugate[x]]]\)], "Input"],

Cell[BoxData[
    \(4.3723114938987637`*^-11 - 
      2.281074455179985`*^-28\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`NFFT\^T\)]]], "Section"],

Cell[TextData[{
  "The routine nfftTranspose computes the value of the sum ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(j \[Element] I\_M\%1\)f\_j\ \
\[ExponentialE]\^\(2\ \[Pi]i\ k\ \[Nu]\_j\)\)],
    TextAlignment->Center],
  " (k\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`I\_N\%d\)]],
  ").  The NFFT sum can be seen as a matrix multiplication ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", "=", 
          RowBox[{
            StyleBox["A",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox[
              OverscriptBox[
                StyleBox["f",
                  FontWeight->"Plain"], "^"],
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["A",
              FontWeight->"Bold"], "jk"], 
          "=", \(\[ExponentialE]\^\(\(-2\)\ \[Pi]\ i\ \((j - N\/2)\)\ \
\[Nu]\_k\)\ \((j \[Element] 0.  . N - 1)\)\)}], TraditionalForm]]],
  ".  In that case the sum ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(j \[Element] I\_M\%1\)f\_j\ \
\[ExponentialE]\^\(2\ \[Pi]i\ k\ \[Nu]\_j\)\)],
    TextAlignment->Center],
  " (k\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`I\_N\%d\)]],
  ") can then be seen as the matrix equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\&^\), "=", 
          RowBox[{
            StyleBox[
              SuperscriptBox["A", 
                StyleBox["T",
                  FontWeight->"Plain"]],
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["f",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  ".  As an example of the use of nfftTranspose consider a decaying signal \
sampled at 39 exponentially increasing intervals."
}], "Text"],

Cell[BoxData[{
    \(\(samplepoints = 
        FoldList[Plus, 0, 
          Table[\[Delta]\^i, {i, 0, 39}] /. 
            FindRoot[
              Sum[\[Delta]\^\(\(i\)\(\ \)\), {i, 0, n - 1}] \[Equal] 
                  255 /. {n \[Rule] 40}, {\[Delta], 
                0}]];\)\), "\[IndentingNewLine]", 
    \(\(data = 
        Exp[2\ \[Pi]\ I\ \((0.25 + 0.01\ I)\)\ samplepoints];\)\)}], "Input"],

Cell["relabeling the sample points as", "Text"],

Cell[BoxData[
    \(\(\[Nu] = \(-\(samplepoints\/510\)\);\)\)], "Input"],

Cell["\<\
and computing the transposed nonequispaced Fourier transform at 512 \
points\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(result = nfftTranspose[data, Transpose[{\[Nu]}], {512}];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Part::"partd"\), \(\(:\)\(\ \)\), "\<\"Part specification \
\\!\\(nfft`Private`w \[LeftDoubleBracket] 1 \[RightDoubleBracket]\\) is \
longer than depth of object. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::partd\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[TextData[{
  "results in an approximation of the sum ",
  Cell[BoxData[
      \(TraditionalForm\`result\[LeftDoubleBracket]
          j\[RightDoubleBracket] = \[Sum]\+\(j \[Element] I\_512\%1\)data\
\[LeftDoubleBracket]
              i\[RightDoubleBracket]\ \[ExponentialE]\^\(\(-2\)\ \[Pi]\ i\ j\ \
\[Nu]\_k\)\)]],
  " which is similar to the Fourier transform of the same signal sampled at \
regular intervals: ",
  Cell[BoxData[
      \(TraditionalForm\`f\&^\_k = \[Sum]\+\(j = 0\)\%255 f\_j\ \
\[ExponentialE]\^\(\(-2\)\ \[Pi]\ i\ j\ k\/512\)\ \((k \[Element] {\(-128. \) \
 .127})\)\)]],
  ".  The two can be compared with:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    \(\(MultipleListPlot[{Transpose[{Range[\(-256\), 254, 2]\/512, 
              Re[RotateRight[
                  Fourier[
                    Exp[2\ \[Pi]\ I\ \((0.25 + 0.01\ I)\)\ Range[0, 255]], 
                    FourierParameters \[Rule] {1, \(-1\)}], 128]]}], 
          Transpose[{Range[\(-256\), 255]\/512, Re[result]}]}, 
        PlotJoined \[Rule] True, PlotStyle \[Rule] {Hue[0, 1, 0], Hue[0]}, 
        SymbolShape \[Rule] None, PlotRange \[Rule] All];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500932 0.954245 0.078396 0.0319671 [
[.11923 .0659 -12 -9 ]
[.11923 .0659 12 0 ]
[.31008 .0659 -12 -9 ]
[.31008 .0659 12 0 ]
[.69178 .0659 -9 -9 ]
[.69178 .0659 9 0 ]
[.88263 .0659 -9 -9 ]
[.88263 .0659 9 0 ]
[.48843 .15831 -18 -4.5 ]
[.48843 .15831 0 4.5 ]
[.48843 .23823 -6 -4.5 ]
[.48843 .23823 0 4.5 ]
[.48843 .31815 -18 -4.5 ]
[.48843 .31815 0 4.5 ]
[.48843 .39807 -12 -4.5 ]
[.48843 .39807 0 4.5 ]
[.48843 .47798 -24 -4.5 ]
[.48843 .47798 0 4.5 ]
[.48843 .5579 -12 -4.5 ]
[.48843 .5579 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11923 .0784 m
.11923 .08465 L
s
[(-0.4)] .11923 .0659 0 1 Mshowa
.31008 .0784 m
.31008 .08465 L
s
[(-0.2)] .31008 .0659 0 1 Mshowa
.69178 .0784 m
.69178 .08465 L
s
[(0.2)] .69178 .0659 0 1 Mshowa
.88263 .0784 m
.88263 .08465 L
s
[(0.4)] .88263 .0659 0 1 Mshowa
.125 Mabswid
.16695 .0784 m
.16695 .08215 L
s
.21466 .0784 m
.21466 .08215 L
s
.26237 .0784 m
.26237 .08215 L
s
.3578 .0784 m
.3578 .08215 L
s
.40551 .0784 m
.40551 .08215 L
s
.45322 .0784 m
.45322 .08215 L
s
.54864 .0784 m
.54864 .08215 L
s
.59636 .0784 m
.59636 .08215 L
s
.64407 .0784 m
.64407 .08215 L
s
.73949 .0784 m
.73949 .08215 L
s
.78721 .0784 m
.78721 .08215 L
s
.83492 .0784 m
.83492 .08215 L
s
.07152 .0784 m
.07152 .08215 L
s
.02381 .0784 m
.02381 .08215 L
s
.93034 .0784 m
.93034 .08215 L
s
.97805 .0784 m
.97805 .08215 L
s
.25 Mabswid
0 .0784 m
1 .0784 L
s
.50093 .15831 m
.50718 .15831 L
s
[(2.5)] .48843 .15831 1 0 Mshowa
.50093 .23823 m
.50718 .23823 L
s
[(5)] .48843 .23823 1 0 Mshowa
.50093 .31815 m
.50718 .31815 L
s
[(7.5)] .48843 .31815 1 0 Mshowa
.50093 .39807 m
.50718 .39807 L
s
[(10)] .48843 .39807 1 0 Mshowa
.50093 .47798 m
.50718 .47798 L
s
[(12.5)] .48843 .47798 1 0 Mshowa
.50093 .5579 m
.50718 .5579 L
s
[(15)] .48843 .5579 1 0 Mshowa
.125 Mabswid
.50093 .01446 m
.50468 .01446 L
s
.50093 .03045 m
.50468 .03045 L
s
.50093 .04643 m
.50468 .04643 L
s
.50093 .06241 m
.50468 .06241 L
s
.50093 .09438 m
.50468 .09438 L
s
.50093 .11036 m
.50468 .11036 L
s
.50093 .12635 m
.50468 .12635 L
s
.50093 .14233 m
.50468 .14233 L
s
.50093 .1743 m
.50468 .1743 L
s
.50093 .19028 m
.50468 .19028 L
s
.50093 .20626 m
.50468 .20626 L
s
.50093 .22225 m
.50468 .22225 L
s
.50093 .25421 m
.50468 .25421 L
s
.50093 .2702 m
.50468 .2702 L
s
.50093 .28618 m
.50468 .28618 L
s
.50093 .30217 m
.50468 .30217 L
s
.50093 .33413 m
.50468 .33413 L
s
.50093 .35012 m
.50468 .35012 L
s
.50093 .3661 m
.50468 .3661 L
s
.50093 .38208 m
.50468 .38208 L
s
.50093 .41405 m
.50468 .41405 L
s
.50093 .43003 m
.50468 .43003 L
s
.50093 .44602 m
.50468 .44602 L
s
.50093 .462 m
.50468 .462 L
s
.50093 .49397 m
.50468 .49397 L
s
.50093 .50995 m
.50468 .50995 L
s
.50093 .52594 m
.50468 .52594 L
s
.50093 .54192 m
.50468 .54192 L
s
.50093 .57389 m
.50468 .57389 L
s
.50093 .58987 m
.50468 .58987 L
s
.50093 .60585 m
.50468 .60585 L
s
.25 Mabswid
.50093 0 m
.50093 .61803 L
s
0 0 0 r
.001 w
.02381 .09538 m
.02754 .09536 L
.03126 .09534 L
.03499 .09531 L
.03872 .09529 L
.04245 .09527 L
.04617 .09525 L
.0499 .09524 L
.05363 .09522 L
.05736 .0952 L
.06108 .09519 L
.06481 .09517 L
.06854 .09516 L
.07227 .09514 L
.07599 .09513 L
.07972 .09512 L
.08345 .09511 L
.08718 .09509 L
.0909 .09508 L
.09463 .09507 L
.09836 .09506 L
.10209 .09505 L
.10581 .09504 L
.10954 .09503 L
.11327 .09502 L
.117 .09502 L
.12073 .09501 L
.12445 .095 L
.12818 .09499 L
.13191 .09499 L
.13564 .09498 L
.13936 .09497 L
.14309 .09497 L
.14682 .09496 L
.15055 .09496 L
.15427 .09495 L
.158 .09495 L
.16173 .09494 L
.16546 .09494 L
.16918 .09493 L
.17291 .09493 L
.17664 .09492 L
.18037 .09492 L
.18409 .09492 L
.18782 .09491 L
.19155 .09491 L
.19528 .09491 L
.199 .0949 L
.20273 .0949 L
.20646 .0949 L
Mistroke
.21019 .0949 L
.21391 .09489 L
.21764 .09489 L
.22137 .09489 L
.2251 .09489 L
.22882 .09489 L
.23255 .09489 L
.23628 .09489 L
.24001 .09488 L
.24373 .09488 L
.24746 .09488 L
.25119 .09488 L
.25492 .09488 L
.25864 .09488 L
.26237 .09488 L
.2661 .09488 L
.26983 .09488 L
.27355 .09488 L
.27728 .09488 L
.28101 .09488 L
.28474 .09488 L
.28846 .09489 L
.29219 .09489 L
.29592 .09489 L
.29965 .09489 L
.30337 .09489 L
.3071 .09489 L
.31083 .09489 L
.31456 .0949 L
.31828 .0949 L
.32201 .0949 L
.32574 .0949 L
.32947 .09491 L
.33319 .09491 L
.33692 .09491 L
.34065 .09492 L
.34438 .09492 L
.3481 .09492 L
.35183 .09493 L
.35556 .09493 L
.35929 .09494 L
.36301 .09494 L
.36674 .09495 L
.37047 .09495 L
.3742 .09496 L
.37792 .09496 L
.38165 .09497 L
.38538 .09497 L
.38911 .09498 L
.39283 .09499 L
Mistroke
.39656 .09499 L
.40029 .095 L
.40402 .09501 L
.40774 .09502 L
.41147 .09502 L
.4152 .09503 L
.41893 .09504 L
.42265 .09505 L
.42638 .09506 L
.43011 .09507 L
.43384 .09508 L
.43756 .09509 L
.44129 .09511 L
.44502 .09512 L
.44875 .09513 L
.45247 .09514 L
.4562 .09516 L
.45993 .09517 L
.46366 .09519 L
.46738 .0952 L
.47111 .09522 L
.47484 .09524 L
.47857 .09525 L
.48229 .09527 L
.48602 .09529 L
.48975 .09531 L
.49348 .09534 L
.4972 .09536 L
.50093 .09538 L
.50466 .09541 L
.50839 .09543 L
.51211 .09546 L
.51584 .09549 L
.51957 .09552 L
.5233 .09555 L
.52702 .09559 L
.53075 .09562 L
.53448 .09566 L
.53821 .0957 L
.54193 .09575 L
.54566 .09579 L
.54939 .09584 L
.55312 .09589 L
.55684 .09594 L
.56057 .096 L
.5643 .09606 L
.56803 .09613 L
.57175 .0962 L
.57548 .09627 L
.57921 .09635 L
Mistroke
.58294 .09644 L
.58666 .09653 L
.59039 .09663 L
.59412 .09674 L
.59785 .09685 L
.60157 .09698 L
.6053 .09711 L
.60903 .09726 L
.61276 .09742 L
.61648 .0976 L
.62021 .09779 L
.62394 .098 L
.62767 .09823 L
.6314 .09849 L
.63512 .09877 L
.63885 .09908 L
.64258 .09944 L
.64631 .09983 L
.65003 .10027 L
.65376 .10078 L
.65749 .10135 L
.66122 .102 L
.66494 .10275 L
.66867 .10362 L
.6724 .10464 L
.67613 .10583 L
.67985 .10725 L
.68358 .10895 L
.68731 .11101 L
.69104 .11354 L
.69476 .11669 L
.69849 .12069 L
.70222 .12584 L
.70595 .13263 L
.70967 .14181 L
.7134 .15457 L
.71713 .1729 L
.72086 .20022 L
.72458 .24239 L
.72831 .30892 L
.73204 .41049 L
.73577 .53596 L
.73949 .60332 L
.74322 .53596 L
.74695 .41049 L
.75068 .30892 L
.7544 .24239 L
.75813 .20022 L
.76186 .1729 L
.76559 .15457 L
Mistroke
.76931 .14181 L
.77304 .13263 L
.77677 .12584 L
.7805 .12069 L
.78422 .11669 L
.78795 .11354 L
.79168 .11101 L
.79541 .10895 L
.79913 .10725 L
.80286 .10583 L
.80659 .10464 L
.81032 .10362 L
.81404 .10275 L
.81777 .102 L
.8215 .10135 L
.82523 .10078 L
.82895 .10027 L
.83268 .09983 L
.83641 .09944 L
.84014 .09908 L
.84386 .09877 L
.84759 .09849 L
.85132 .09823 L
.85505 .098 L
.85877 .09779 L
.8625 .0976 L
.86623 .09742 L
.86996 .09726 L
.87368 .09711 L
.87741 .09698 L
.88114 .09685 L
.88487 .09674 L
.88859 .09663 L
.89232 .09653 L
.89605 .09644 L
.89978 .09635 L
.9035 .09627 L
.90723 .0962 L
.91096 .09613 L
.91469 .09606 L
.91841 .096 L
.92214 .09594 L
.92587 .09589 L
.9296 .09584 L
.93332 .09579 L
.93705 .09575 L
.94078 .0957 L
.94451 .09566 L
.94823 .09562 L
.95196 .09559 L
Mistroke
.95569 .09555 L
.95942 .09552 L
.96314 .09549 L
.96687 .09546 L
.9706 .09543 L
.97433 .09541 L
Mfstroke
1 0 0 r
.02381 .01472 m
.02567 .02108 L
.02754 .02652 L
.0294 .03029 L
.03126 .03189 L
.03313 .0313 L
.03499 .02903 L
.03686 .02616 L
.03872 .02403 L
.04058 .02351 L
.04245 .0245 L
.04431 .02607 L
.04617 .02726 L
.04804 .02776 L
.0499 .02796 L
.05177 .02845 L
.05363 .02985 L
.05549 .03281 L
.05736 .03803 L
.05922 .04591 L
.06108 .05642 L
.06295 .06889 L
.06481 .08216 L
.06668 .09489 L
.06854 .10609 L
.0704 .11529 L
.07227 .12244 L
.07413 .12758 L
.07599 .13073 L
.07786 .13198 L
.07972 .13167 L
.08159 .13053 L
.08345 .12959 L
.08531 .12986 L
.08718 .132 L
.08904 .13602 L
.0909 .14107 L
.09277 .146 L
.09463 .15011 L
.0965 .1536 L
.09836 .1572 L
.10022 .16146 L
.10209 .16645 L
.10395 .17187 L
.10581 .17715 L
.10768 .18143 L
.10954 .18365 L
.11141 .18291 L
.11327 .17881 L
.11513 .17168 L
Mistroke
.117 .16248 L
.11886 .15236 L
.12073 .14223 L
.12259 .13272 L
.12445 .12434 L
.12632 .11755 L
.12818 .11268 L
.13004 .10968 L
.13191 .10796 L
.13377 .10649 L
.13564 .10415 L
.1375 .10025 L
.13936 .09492 L
.14123 .08896 L
.14309 .08308 L
.14495 .0773 L
.14682 .07111 L
.14868 .064 L
.15055 .05578 L
.15241 .04657 L
.15427 .037 L
.15614 .02812 L
.158 .0212 L
.15986 .01729 L
.16173 .01681 L
.16359 .01939 L
.16546 .02423 L
.16732 .03047 L
.16918 .03729 L
.17105 .04393 L
.17291 .04961 L
.17477 .05382 L
.17664 .05655 L
.1785 .0584 L
.18037 .06043 L
.18223 .06357 L
.18409 .06805 L
.18596 .07343 L
.18782 .07919 L
.18968 .08533 L
.19155 .09229 L
.19341 .10052 L
.19528 .11022 L
.19714 .12113 L
.199 .13242 L
.20087 .1428 L
.20273 .15091 L
.20459 .1559 L
.20646 .15765 L
.20832 .15666 L
Mistroke
.21019 .15365 L
.21205 .14946 L
.21391 .14501 L
.21578 .14115 L
.21764 .13836 L
.2195 .13648 L
.22137 .13475 L
.22323 .13224 L
.2251 .12849 L
.22696 .12368 L
.22882 .11816 L
.23069 .11189 L
.23255 .1045 L
.23441 .09563 L
.23628 .08523 L
.23814 .07384 L
.24001 .0626 L
.24187 .05294 L
.24373 .04603 L
.2456 .04234 L
.24746 .04163 L
.24932 .04322 L
.25119 .04625 L
.25305 .04975 L
.25492 .0529 L
.25678 .05538 L
.25864 .05753 L
.26051 .06014 L
.26237 .06386 L
.26423 .06877 L
.2661 .07464 L
.26796 .08142 L
.26983 .08936 L
.27169 .09866 L
.27355 .10913 L
.27542 .11997 L
.27728 .12984 L
.27914 .13738 L
.28101 .14175 L
.28287 .14289 L
.28474 .1414 L
.2866 .13818 L
.28846 .13423 L
.29033 .13035 L
.29219 .12684 L
.29405 .12332 L
.29592 .11912 L
.29778 .1138 L
.29965 .10741 L
.30151 .10016 L
Mistroke
.30337 .09206 L
.30524 .08311 L
.3071 .07363 L
.30896 .06449 L
.31083 .05698 L
.31269 .05234 L
.31456 .05113 L
.31642 .05308 L
.31828 .05731 L
.32015 .06274 L
.32201 .06839 L
.32387 .07379 L
.32574 .07904 L
.3276 .08468 L
.32947 .0911 L
.33133 .09822 L
.33319 .10575 L
.33506 .11343 L
.33692 .12094 L
.33878 .12763 L
.34065 .13247 L
.34251 .13438 L
.34438 .1328 L
.34624 .12809 L
.3481 .1213 L
.34997 .1137 L
.35183 .10628 L
.35369 .09951 L
.35556 .09326 L
.35742 .08711 L
.35929 .08091 L
.36115 .07494 L
.36301 .06965 L
.36488 .06549 L
.36674 .06299 L
.3686 .06289 L
.37047 .06582 L
.37233 .0718 L
.3742 .08 L
.37606 .08902 L
.37792 .0975 L
.37979 .10462 L
.38165 .11022 L
.38352 .11462 L
.38538 .11809 L
.38724 .12056 L
.38911 .12161 L
.39097 .12087 L
.39283 .11805 L
.3947 .11295 L
Mistroke
.39656 .10567 L
.39843 .09693 L
.40029 .0881 L
.40215 .08068 L
.40402 .07563 L
.40588 .0731 L
.40774 .07266 L
.40961 .07377 L
.41147 .07618 L
.41334 .07998 L
.4152 .08522 L
.41706 .09171 L
.41893 .09903 L
.42079 .1064 L
.42265 .11268 L
.42452 .11661 L
.42638 .11743 L
.42825 .1153 L
.43011 .11108 L
.43197 .10575 L
.43384 .09998 L
.4357 .09407 L
.43756 .08827 L
.43943 .08306 L
.44129 .07913 L
.44316 .07722 L
.44502 .07797 L
.44688 .08159 L
.44875 .08744 L
.45061 .09421 L
.45247 .10054 L
.45434 .10557 L
.4562 .10899 L
.45807 .11072 L
.45993 .11061 L
.46179 .10848 L
.46366 .10435 L
.46552 .09866 L
.46738 .09237 L
.46925 .08686 L
.47111 .0834 L
.47298 .08255 L
.47484 .08407 L
.4767 .08734 L
.47857 .09176 L
.48043 .09679 L
.48229 .10175 L
.48416 .10575 L
.48602 .10786 L
.48789 .1074 L
Mistroke
.48975 .10442 L
.49161 .09982 L
.49348 .09488 L
.49534 .09068 L
.4972 .08787 L
.49907 .08683 L
.50093 .08782 L
.5028 .09078 L
.50466 .09513 L
.50652 .09978 L
.50839 .10334 L
.51025 .10484 L
.51211 .10411 L
.51398 .10162 L
.51584 .09806 L
.51771 .09428 L
.51957 .09121 L
.52143 .08977 L
.5233 .09051 L
.52516 .0932 L
.52702 .09684 L
.52889 .10018 L
.53075 .10227 L
.53262 .10264 L
.53448 .10124 L
.53634 .0985 L
.53821 .09536 L
.54007 .09303 L
.54193 .09243 L
.5438 .09366 L
.54566 .09612 L
.54753 .09885 L
.54939 .10089 L
.55125 .10148 L
.55312 .1004 L
.55498 .09818 L
.55684 .09592 L
.55871 .09466 L
.56057 .09489 L
.56244 .09643 L
.5643 .09855 L
.56616 .10027 L
.56803 .10076 L
.56989 .09986 L
.57175 .09821 L
.57362 .09678 L
.57548 .09634 L
.57735 .09711 L
.57921 .09865 L
.58107 .10005 L
Mistroke
.58294 .10051 L
.5848 .09991 L
.58666 .09877 L
.58853 .09794 L
.59039 .098 L
.59226 .09893 L
.59412 .10008 L
.59598 .10067 L
.59785 .10044 L
.59971 .09973 L
.60157 .09925 L
.60344 .09947 L
.6053 .10025 L
.60717 .101 L
.60903 .10121 L
.61089 .10091 L
.61276 .10058 L
.61462 .10072 L
.61648 .1013 L
.61835 .10188 L
.62021 .10207 L
.62208 .10195 L
.62394 .10194 L
.6258 .10229 L
.62767 .10281 L
.62953 .10316 L
.6314 .10327 L
.63326 .10339 L
.63512 .10374 L
.63699 .10422 L
.63885 .10458 L
.64071 .10482 L
.64258 .10513 L
.64444 .10559 L
.64631 .10607 L
.64817 .10646 L
.65003 .10687 L
.6519 .10738 L
.65376 .10793 L
.65562 .10846 L
.65749 .10901 L
.65935 .10965 L
.66122 .11031 L
.66308 .11099 L
.66494 .11173 L
.66681 .11253 L
.66867 .11337 L
.67053 .11428 L
.6724 .11525 L
.67426 .11629 L
Mistroke
.67613 .11741 L
.67799 .11861 L
.67985 .11991 L
.68172 .12131 L
.68358 .12283 L
.68544 .12448 L
.68731 .12627 L
.68917 .12822 L
.69104 .13034 L
.6929 .13267 L
.69476 .13522 L
.69663 .13802 L
.69849 .1411 L
.70035 .14451 L
.70222 .14829 L
.70408 .15248 L
.70595 .15716 L
.70781 .16239 L
.70967 .16825 L
.71154 .17485 L
.7134 .1823 L
.71526 .19074 L
.71713 .20031 L
.71899 .21121 L
.72086 .22363 L
.72272 .23778 L
.72458 .25385 L
.72645 .27196 L
.72831 .29208 L
.73017 .31385 L
.73204 .33629 L
.7339 .35753 L
.73577 .37472 L
.73763 .3845 L
.73949 .3845 L
.74136 .37472 L
.74322 .35753 L
.74508 .33629 L
.74695 .31385 L
.74881 .29208 L
.75068 .27196 L
.75254 .25385 L
.7544 .23778 L
.75627 .22363 L
.75813 .21121 L
.75999 .20031 L
.76186 .19074 L
.76372 .1823 L
.76559 .17485 L
.76745 .16825 L
Mistroke
.76931 .16239 L
.77118 .15716 L
.77304 .15248 L
.7749 .14829 L
.77677 .14451 L
.77863 .1411 L
.7805 .13802 L
.78236 .13522 L
.78422 .13267 L
.78609 .13034 L
.78795 .12822 L
.78981 .12627 L
.79168 .12448 L
.79354 .12283 L
.79541 .12131 L
.79727 .11991 L
.79913 .11861 L
.801 .11741 L
.80286 .11629 L
.80472 .11525 L
.80659 .11428 L
.80845 .11337 L
.81032 .11253 L
.81218 .11173 L
.81404 .11099 L
.81591 .11031 L
.81777 .10965 L
.81963 .10901 L
.8215 .10846 L
.82336 .10793 L
.82523 .10738 L
.82709 .10687 L
.82895 .10646 L
.83082 .10607 L
.83268 .10559 L
.83454 .10513 L
.83641 .10482 L
.83827 .10458 L
.84014 .10422 L
.842 .10374 L
.84386 .10339 L
.84573 .10327 L
.84759 .10316 L
.84945 .10281 L
.85132 .10229 L
.85318 .10194 L
.85505 .10195 L
.85691 .10207 L
.85877 .10188 L
.86064 .1013 L
Mistroke
.8625 .10072 L
.86436 .10058 L
.86623 .10091 L
.86809 .10121 L
.86996 .101 L
.87182 .10025 L
.87368 .09947 L
.87555 .09925 L
.87741 .09973 L
.87927 .10044 L
.88114 .10067 L
.883 .10008 L
.88487 .09893 L
.88673 .098 L
.88859 .09794 L
.89046 .09877 L
.89232 .09991 L
.89419 .10051 L
.89605 .10005 L
.89791 .09865 L
.89978 .09711 L
.90164 .09634 L
.9035 .09678 L
.90537 .09821 L
.90723 .09986 L
.9091 .10076 L
.91096 .10027 L
.91282 .09855 L
.91469 .09643 L
.91655 .09489 L
.91841 .09466 L
.92028 .09592 L
.92214 .09818 L
.92401 .1004 L
.92587 .10148 L
.92773 .10089 L
.9296 .09885 L
.93146 .09612 L
.93332 .09366 L
.93519 .09243 L
.93705 .09303 L
.93892 .09536 L
.94078 .0985 L
.94264 .10124 L
.94451 .10264 L
.94637 .10227 L
.94823 .10018 L
.9501 .09684 L
.95196 .0932 L
.95383 .09051 L
Mistroke
.95569 .08977 L
.95755 .09121 L
.95942 .09428 L
.96128 .09806 L
.96314 .10162 L
.96501 .10411 L
.96687 .10484 L
.96874 .10334 L
.9706 .09978 L
.97246 .09513 L
.97433 .09078 L
.97619 .08782 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oSoooool0
0ol0003oooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`00Soooool00ol0003o
ooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`001oooool00ooo003ooooooooo
o`0Tooooo`03ool00?oooooooooo05kooooo0_l0002?ooooo`001oooool00ooo003oooooooooo`0T
ooooo`;oo`00Goooool00ol0003oooooooooo`2>ooooo`001oooool01Ooo003ooooooooooooooooo
o`00027ooooo00?oo`00oooooooo0000Goooool00ol0003oooooooooo`2>ooooo`002?ooool01?oo
003oooooool00?ooool2ool001oooooo00?oo`00oooooooo0000Goooool00ol0003oooooooooo`2>
ooooo`002?ooool00ooo003oooooool00003ooooo`;oo`007Oooool01?oo003ooooooooooooo001N
ooooo`;o0000Soooool000Wooooo00?oo`00ooooooooool01?ooool00ooo003oooooooooo`0Joooo
o`04ool00?ooooooooooool005kooooo00?o0000ooooooooool0S_ooool0013ooooo00?oo`00oooo
ooooool02oooool2o`0000Cooooo00?o0000ooooooooool00oooool2o`000005ool00?oooooooooo
oooooooo00009?ooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol0000[ooooo`03o`000?oo
oooooooo02gooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go0000:?ooool2o`0000Cooooo
00?o0000ooooooooool00oooool3o`0001_ooooo000@ooooo`03ool00?oooooooooo00[ooooo00Co
0000oooooooooooo00002_ooool00ol0003oo`00ooooo`02ooooo`03ool00?oooooooooo01Cooooo
00?oo`00ooooooooool02_ooool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`00
02_ooooo00?o0000ooooooooool0;?ooool01?l0003oooooooooool00008ooooo`04o`000?oooooo
ooooo`0002Oooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0Jooooo`004Ooo
ool00ooo003oooooooooo`02ooooo`Go00000_ooool01?l0003oooooooooool00007ooooo`?o0000
00?oo`00o`000?ooool00oooool00ooo003oooooooooo`0Booooo`;oo`001Oooool5o`0000;ooooo
00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02co
oooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`0Wooooo`04o`000?oooooooooo
o`0000Oooooo1Ol0000Kooooo`004Oooool00ooo003oooooooooo`09ooooo`04o`000?oooooooooo
o`0000Oooooo00Co0000ooooooooooooo`001Oooool00ooo003oooooooooo`0Booooo`03ool00?oo
ooooo`0000_ooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0Zooooo`;o0000
;Oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo02Kooooo00Co0000oooooooo
oooo00001oooool01?l0003oooooooooool0000Looooo`004Oooool00ooo003oooooooooo`09oooo
o`04o`000?ooooooooooo`0000Sooooo00?o0000oooooooo00001Oooool00ooo003oooooooooo`0B
ooooo`03ool00?ooooooo`0000_ooooo00Co0000oooooooooooo00000_ooool00ooo003ooooooooo
o`02ooooo`05o`000?ooooooooooooooool00000:oooool00ol0003oooooooooo`0/ooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000Wooooo`04o`000?oooooooooo
o`0000Sooooo00?o0000ooooool000007?ooool0017ooooo00?oo`00ooooooooool02Oooool01?l0
003oooooooooool00009ooooo`03o`000?oo003ooooo00Gooooo00?oo`00ooooooooool04?ooool0
1Ooo003oooooooooooooooooo`0000[ooooo00Go0000oooooooooooo0000ooooo`02ool000Cooooo
00Go0000ooooooooooooooooo`00000[ooooo`03o`000?oooooooooo02cooooo00Co0000oooooooo
oooo00001oooool01Ol0003ooooooooooooooooo000002Oooooo00Co0000oooooooooooo00002Ooo
ool2o`0001cooooo000Aooooo`03ool00?oooooooooo00[ooooo0_l0000;ooooo`03ool00?oooooo
oooo00Cooooo0_oo000Aooooo`03ool00?oooooooooo00;ooooo00?oo`00ooooooooool02?ooool2
o`0000;ooooo00?oo`00oooooooo00001?ooool3o`0002cooooo00?o0000ooooooooool0;Oooool2
o`0000Wooooo0ol0000Yooooo`;o00002oooool00ol0003oooooooooo`0Jooooo`004Oooool00ooo
003oooooooooo`0Gooooo`03ool00?oooooooooo00Gooooo00?oo`00ooooooooool03oooool00ooo
003oooooooooo`02ooooo`03ool00?oooooooooo00cooooo00?oo`00oooooooo0000<oooool2o`00
08oooooo000Booooo`03ool00?oooooooooo01Gooooo00?oo`00ooooooooool01oooool00ooo003o
ooooooooo`0>ooooo`03ool00?oooooooooo00?ooooo00?oo`00ooooooooool02_ooool01Ooo003o
ooooooooooooooooo`0000_ooooo0ooo000Tooooo`03o`000?oooooooooo08kooooo000Booooo`03
ool00?oooooooooo01Gooooo00?oo`00ooooooooool02?ooool00ooo003oooooooooo`0=ooooo`03
ool00?oooooooooo00Cooooo00?oo`00ooooooooool02Oooool01Ooo003oooooooooooooooooo`00
00_ooooo00?oo`00oooooooo00009?ooool00ol0003oooooooooo`2>ooooo`004_ooool00ooo003o
ooooooooo`0Eooooo`03ool00?oooooooooo00Sooooo00?oo`00ooooooooool03?ooool00ooo003o
ooooooooo`05ooooo`03ool00?oooooooooo00Wooooo00Goo`00ooooooooooooooooool0000;oooo
o`03ool00?ooooooo`0000Wooooo0_oo000Iooooo`03o`000?oooooooooo08kooooo000Booooo`03
ool00?oooooooooo01Gooooo00?oo`00ooooooooool02?ooool00ooo003oooooooooo`0<ooooo`03
ool00?oooooooooo00Gooooo00?oo`00ooooooooool02Oooool00ooo003oooooooooo`02ooooo`03
ool00?oooooooooo00Oooooo00Coo`00ooooooooooooo`002Oooool3ool001Sooooo00?o0000oooo
ooooool0S_ooool001;o000000?oo`00o`000?l000005?l000000ooo003o0000o`00000:o`000003
ool00?l0003o000000_o000000?oo`00o`000?l000001Ol000000ooo003o0000o`000009o`000003
ool00?l0003o000000;o000000?oo`00o`000?l000001ol000001Ooo003o0000o`000?l0003oo`00
00So000000?oo`00o`000?oo00001ol00002ool009oo00000Oooool000Oooooo00?o0000oooooooo
ool02?ooool00ooo003oooooo`00000=ooooo`03o`000?oooooooooo00Cooooo00?oo`00oooooooo
ool01?ooool00ol0003oooooooooo`03ooooo`03ool00?oooooooooo00Cooooo00?o0000oooooooo
ool01?ooool00ooo003oooooooooo`04ooooo`03o`000?ooooooo`0000Wooooo00?oo`00ooooool0
00000oooool00ooo003oooooooooo`06ooooo`03o`000?oo003ooooo00;ooooo00?oo`00oooooooo
ool01Oooool01?oo003o0000oooooooo0007ooooo`05ool00?ooooooo`00ooooool000001?ooool0
0ooo003oooooooooo`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01Oooool0
01;ooooo00?oo`00ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03ool00?oooooooooo
00[ooooo00?oo`00ooooooooool02oooool00ooo003oooooooooo`06ooooo`03ool00?oooooooooo
00Oooooo00?oo`00ooooool000001?ooool00ooo003oooooooooo`06ooooo`03ool00?oooooooooo
00;ooooo00?oo`00ooooooooool01?ooool01Ooo003oooooooooooooooooo`0000Kooooo00?oo`00
oooooooo00001Oooool00ooo003oooooool00006ooooo`03ool00?oooooooooo03Cooooo00?o0000
ooooooooool0=?ooool00ol0003oooooooooo`0Pooooo`004_ooool00ooo003oooooooooo`0Coooo
o`03ool00?oooooooooo00_ooooo00?oo`00ooooooooool02oooool00ooo003oooooooooo`06oooo
o`03ool00?oooooooooo00Oooooo00?oo`00ooooooooool01?ooool00ooo003oooooooooo`05oooo
o`03ool00?oooooooooo00?ooooo00?oo`00ooooooooool00oooool00ooo003oooooooooo`02oooo
o`03ool00?oooooooooo00?ooooo00Coo`00ooooooooooooo`001Oooool00ooo003oooooool00005
ooooo`;oo`001Oooool2ool007[ooooo00?oo`00ooooooooool00oooool00ooo003oooooooooo`06
ooooo`004oooool00ooo003oooooooooo`0Booooo`03ool00?oooooooooo00cooooo00?oo`00oooo
ooooool02Oooool00ooo003oooooooooo`07ooooo`03ool00?oooooooooo00Oooooo00?oo`00oooo
ooooool01?ooool00ooo003oooooooooo`05ooooo`03ool00?oooooooooo00?ooooo00?oo`00oooo
ooooool00oooool00ooo003oooooooooo`02ooooo`03ool00?oooooooooo00?ooooo00Coo`00oooo
ooooooooo`001Oooool01?oo003ooooooooooooo0004ooooo`03ool00?l0003oo`0000Cooooo0_oo
0003ooooo`?oo`00K_ooool2ool000?ooooo00?oo`00oooooooo00001?ooool00ooo003ooooooooo
o`06ooooo`001oooool<o`000003ool00?l0003o000001;o000000?oo`00o`000?l000003?l00000
0ooo003o0000o`000009o`000003ool00?l0003o000000So000000?oo`00o`000?l000001_l00000
0ooo003o0000o`000004o`000003ool00?l0003o000000Go000000?oo`00o`000?l000000ol00000
0ooo003o0000o`000003o`000003ool00?l0003o000000;o000000?oo`00o`000?l000000ol00000
1Ooo003o0000o`000?l0003oo`0000Co000000Coo`00o`000?l0003oo`000ol000001?oo003o0000
o`000?oo0003o`000004ool00?l0003o0000ool000;o000000?oo`00o`000?oo00000_l00003ool0
00;o00000_oo000:o`0004Sooooo2Ol00003ool000;o00000_oo0003o`000003ool00?l0003oo`00
00;o000000Coo`00o`000?l0003oo`000_l000000ooo003o0000ooooo`07ooooo`004oooool00ooo
003oooooooooo`0Aooooo`03ool00?oooooooooo00gooooo00?oo`00ooooooooool02Oooool00ooo
003oooooooooo`08ooooo`03ool00?oooooooooo00Gooooo00?oo`00ooooooooool01_ooool00ooo
003oooooooooo`03ooooo`03ool00?oooooooooo00Cooooo00?oo`00ooooooooool00oooool00ooo
003oooooooooo`03ooooo`05ool00?oooooooooooooooooo00001?ooool01Ooo003ooooooooooooo
ooooo`0000?ooooo00Woo`00ooooooooooooooooool00?oooooo0000oooooooo00000_ooool01_oo
003ooooooooooooo003oooooool000?ooooo0ooo00000oooooooo`00ool00002ool00003oooooooo
003oo`0000Woo`002ol0000`ooooo`_o00002ooo00001?ooooooo`00ool00?oo0002ooooo`?oo`00
0_ooool00ooo003oooooool00003ooooo`04ool00?ooooooooooool000Wooooo000Cooooo`03ool0
0?oooooooooo017ooooo00?oo`00ooooooooool03Oooool00ooo003oooooooooo`08ooooo`03ool0
0?oooooooooo00Wooooo00?oo`00ooooooooool01Oooool00ooo003oooooooooo`06ooooo`03ool0
0?oooooooooo00?ooooo00?oo`00ooooooooool01Oooool01Ooo003oooooooooooooooooo`0000Ko
oooo00Goo`00ooooooooooooooooool00004ooooo`05ool00?oooooooooooooooooo00001?ooool0
0ooo003oooooool00002ooooo`03o`000?ooooooo`0000;oo`001?ooool2ool000Cooooo00?oo`00
ooooooooool03Oooool00ooo003oooooool00006ool000Gooooo1?l0000Xooooo`Co00001?ooool7
ool00003oooooooo003ooooo00oooooo00?oo`00ooooooooool00_ooool2ool000Cooooo0_oo000:
ooooo`004oooool00ooo003oooooooooo`0@ooooo`03ool00?oooooooooo00oooooo00?oo`00oooo
ooooool01oooool00ooo003oooooooooo`09ooooo`03ool00?oooooooooo00Gooooo00?oo`00oooo
ooooool01_ooool00ooo003oooooooooo`03ooooo`03ool00?oooooooooo00Gooooo00Goo`00oooo
ooooooooooooool00006ooooo`05ool00?oooooooooooooooooo00001Oooool01?oo003ooooooooo
oooo0004ooooo`?oo`000_ooool01?l0003ooooooooooooo000Tooooo`Goo`001?ooool4o`00027o
oooo0ol00004ooooo`Goo`009?ooool00ooo003oooooooooo`08ooooo`004oooool00ooo003ooooo
ooooo`0?ooooo`03ool00?oooooooooo013ooooo00?oo`00ooooooooool01oooool00ooo003ooooo
ooooo`09ooooo`03ool00?oooooooooo00Gooooo00?oo`00ooooooooool01_ooool00ooo003ooooo
ooooo`03ooooo`03ool00?oooooooooo00Gooooo00Goo`00ooooooooooooooooool00006ooooo`04
ool00?ooooooooooool000Kooooo0ooo000:ooooo`;o0000:oooool3ool000Gooooo0_l0000Loooo
o`?o00001?ooool3ool003Cooooo000Dooooo`03ool00?oooooooooo00kooooo00?oo`00oooooooo
ool04?ooool00ooo003oooooooooo`07ooooo`03ool00?oooooooooo00Wooooo00?oo`00oooooooo
ool01?ooool00ooo003oooooooooo`08ooooo`05ool00?oooooooooooooooooo00002Oooool01?oo
003ooooooooooooo0007ooooo`03ool00?ooooooo`0001?ooooo00?o0000ooooooooool0;?ooool3
ool000Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`03ooooo`;oo`00=oooool0
01Cooooo00?oo`00ooooooooool03Oooool00ooo003oooooooooo`0Aooooo`03ool00?oooooooooo
00Kooooo00?oo`00ooooooooool02oooool00ooo003oooooooooo`03ooooo`03ool00?oooooooooo
00Sooooo00Goo`00ooooooooooooooooool00009ooooo`03ool00?ooooooo`0000Sooooo0_oo000D
ooooo`03o`000?oooooooooo02kooooo0_oo0005ooooo`03o`000?oooooooooo01Kooooo00?o0000
ooooooooool00_ooool2ool003Wooooo000Dooooo`03ool00?oooooooooo00gooooo00?oo`00oooo
ooooool04Oooool00ooo003oooooooooo`06ooooo`03ool00?oooooooooo00_ooooo00?oo`00oooo
ooooool00oooool00ooo003oooooooooo`08ooooo`05ool00?oooooooooooooooooo00002_ooool2
ool001kooooo00?o0000ooooooooool0<?ooool2ool000Cooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`02ooooo`;oo`00>_ooool001Gooooo00?oo`00ooooooooool02oooool00ooo
003oooooooooo`0Booooo`03ool00?oooooooooo00Kooooo00?oo`00ooooooooool02oooool00ooo
003oooooooooo`02ooooo`03ool00?oooooooooo00Wooooo00Goo`00ooooooooooooooooool0000Z
ooooo`03o`000?oooooooooo03;ooooo00Goo`00ooooooooooooooooo`00000Fooooo`05o`000?oo
oooooooooooooooo0000??ooool001Gooooo00?oo`00ooooooooool02oooool00ooo003ooooooooo
o`0Cooooo`03ool00?oooooooooo00Cooooo00?oo`00ooooooooool03?ooool00ooo003ooooooooo
o`02ooooo`03ool00?oooooooooo00[ooooo00?oo`00oooooooo0000:oooool2o`0003Cooooo00Go
o`00ooooooooooooooooo`00000Dooooo`03o`000?oooooooooo00;oo`00?Oooool001Kooooo1?oo
0009ooooo`03ool00?oooooooooo01?ooooo00?oo`00ooooooooool01?ooool00ooo003ooooooooo
o`0<ooooo`05ool00?oooooooooooooooooo00003Oooool00ooo003oooooool0000[ooooo`03o`00
0?oooooooooo03Cooooo00Coo`00oooooooooooo00005?ooool01?l0003ooooooooooooo000noooo
o`006Oooool00ooo003oooooooooo`07ooooo`03ool00?oooooooooo01?ooooo00?oo`00oooooooo
ool00oooool00ooo003oooooooooo`0=ooooo`04ool00?ooooooooooool000oooooo00?oo`00oooo
ooooool0:_ooool00ol0003oooooooooo`0dooooo`;oo`000_ooool00ol0003oooooooooo`0@oooo
o`04o`000?ooooooooooool003oooooo000Iooooo`03ool00?oooooooooo00Oooooo00?oo`00oooo
ooooool04oooool00ooo003oooooooooo`02ooooo`;oo`004?ooool00ooo003oooooool0000loooo
o`03o`000?oooooooooo03Gooooo00Coo`00oooooooooooo00004_ooool00ol0003oooooool00010
ooooo`006_ooool00ooo003oooooooooo`05ooooo`03ool00?oooooooooo01Cooooo00?oo`00oooo
ooooool00_ooool00ooo003oooooooooo`0?ooooo`;oo`00?Oooool2o`0003Oooooo00Coo`00oooo
oooooooo00004?ooool01?l0003ooooooooooooo0010ooooo`006_ooool00ooo003oooooooooo`05
ooooo`03ool00?oooooooooo01Cooooo00Goo`00ooooooooooooooooool0001Aooooo`03o`000?oo
oooooooo03Kooooo00Coo`00oooooooooooo00004?ooool00ol0003oooooool00011ooooo`006_oo
ool00ooo003oooooooooo`05ooooo`03ool00?oooooooooo01Gooooo00Coo`00ooooooooooooo`00
??ooool5o`0000?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0
=oooool00ooo003oooooo`00000@ooooo`03o`000?ooooooo`00047ooooo000Kooooo`03ool00?oo
oooooooo00Cooooo00?oo`00ooooooooool05Oooool01?oo003ooooooooooooo000mooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
03Oooooo00Coo`00oooooooooooo00003_ooool00ol0003oooooool00012ooooo`006oooool00ooo
003oooooooooo`04ooooo`03ool00?oooooooooo01Gooooo0ooo000oooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0gooooo`04ool00?oooooooooo
o`0000kooooo00?o0000oooooooo0000@_ooool001cooooo00?oo`00ooooooooool00_ooool00ooo
003oooooooooo`0Gooooo`03ool00?oooooooooo03oooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`02ooooo`?o0000>?ooool00ooo003oooooo`00000>ooooo`03o`000?ooooooo`00
04;ooooo000Mooooo`05ool00?oooooooooooooooooo0000F?ooool01Ol0003ooooooooooooooooo
000000Oooooo1?l00005ooooo`03o`000?oooooooooo03Sooooo00?oo`00ooooool000003_ooool0
0ol0003oo`00ooooo`12ooooo`007Oooool01Ooo003oooooooooooooooooo`0005Sooooo00Go0000
ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0>?oo
ool01?oo003oooooooooool0000<ooooo`03o`000?ooooooo`0004?ooooo000Mooooo`05ool00?oo
oooooooooooooooo0000FOooool3o`0000Sooooo1Ol00004ooooo`03o`000?oooooooooo03Wooooo
00?oo`00ooooool000003?ooool00ol0003oooooool00013ooooo`007_ooool01?oo003ooooooooo
oooo001]ooooo`;o0000>_ooool00ooo003oooooo`00000<ooooo`03o`000?ooooooo`0004?ooooo
000Nooooo`04ool00?ooooooooooool006gooooo00?o0000ooooooooool0>_ooool00ooo003o0000
ooooo`0;ooooo`03o`000?oo003ooooo04?ooooo000Nooooo`03ool00?ooooooo`0006kooooo00?o
0000ooooooooool0>_ooool00ooo003o0000ooooo`0;ooooo`03o`000?oo003ooooo04?ooooo000O
ooooo`;oo`00K_ooool00ol0003oooooooooo`0jooooo`03ool00?l0003ooooo00_ooooo00?o0000
ool00?ooool0@oooool008oooooo00?o0000ooooooooool0>_ooool00ooo003o0000ooooo`0;oooo
o`03o`000?oo003ooooo04?ooooo002?ooooo`;o0000??ooool00ooo003o0000ooooo`09ooooo`03
o`000?oo003ooooo04Cooooo002?ooooo`03o`000?oooooooooo03_ooooo00?oo`00o`000?ooool0
2Oooool00ol0003oo`00ooooo`14ooooo`00Soooool00ol0003oooooooooo`0kooooo`03ool00?l0
003ooooo00Wooooo00?oo`00ooooooooool0A?ooool008oooooo00?o0000ooooooooool0>oooool0
0ooo003o0000ooooo`09ooooo`03ool00?oooooooooo04Cooooo002?ooooo`03o`000?oooooooooo
03_ooooo00?oo`00o`000?ooool02Oooool00ooo003oooooooooo`14ooooo`00Soooool2o`0003go
oooo00?oo`00ooooooooool02?ooool00ooo003oooooooooo`14ooooo`00Soooool00ol0003ooooo
ooooo`0looooo`03ool00?oooooooooo00Sooooo00?oo`00ooooooooool0A?ooool008oooooo00?o
0000ooooooooool0??ooool00ooo003oooooooooo`08ooooo`03ool00?oooooooooo04Cooooo002?
ooooo`03o`000?oooooooooo03cooooo00?oo`00ooooooooool02?ooool00ooo003oooooooooo`14
ooooo`00Soooool2o`0003gooooo00?oo`00ooooooooool01oooool00ooo003o0000ooooo`15oooo
o`00Soooool00ol0003oooooooooo`0looooo`03ool00?l0003ooooo00Oooooo00?oo`00oooooooo
ool0AOooool008Oooooo0ol00005ooooo`03o`000?oooooooooo03cooooo00?oo`00o`000?ooool0
1oooool00ooo003oooooooooo`15ooooo`00Q_ooool01Ol0003ooooooooooooooooo000000Cooooo
00?o0000ooooooooool0??ooool00ooo003o0000ooooo`07ooooo`03ool00?oooooooooo04Gooooo
002:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0?Oooool00ooo003ooooooooo
o`06ooooo`03ool00?oooooooooo04Gooooo002:ooooo`03o`000?oooooooooo00;ooooo0ol0000m
ooooo`03ool00?oooooooooo00Kooooo00?oo`00ooooooooool0AOooool008Kooooo1?l00005oooo
o`03o`000?oooooooooo03gooooo00?oo`00ooooooooool01_ooool00ooo003oooooooooo`15oooo
o`00Q_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo03gooooo00?oo`00oooooooo
ool01_ooool00ooo003oooooooooo`15ooooo`00Q_ooool5o`0000Cooooo00?o0000ooooooooool0
?Oooool00ooo003oooooooooo`05ooooo`03ool00?l0003ooooo04Kooooo002?ooooo`;o0000?_oo
ool00ooo003oooooooooo`05ooooo`03ool00?l0003ooooo04Kooooo002?ooooo`03o`000?oooooo
oooo03gooooo00?oo`00ooooooooool01Oooool00ooo003o0000ooooo`16ooooo`00Soooool00ol0
003oooooooooo`0mooooo`03ool00?oooooooooo00Gooooo00?oo`00o`000?ooool0A_ooool008oo
oooo00?o0000ooooooooool0?Oooool00ol0003oo`00ooooo`05ooooo`03ool00?l0003ooooo04Ko
oooo002?ooooo`03o`000?oooooooooo03gooooo00?o0000ool00?ooool01Oooool00ooo003o0000
ooooo`16ooooo`00Soooool2o`0003kooooo00?o0000ool00?ooool01Oooool00ooo003o0000oooo
o`16ooooo`00Soooool00ol0003oooooooooo`0mooooo`03o`000?oo003ooooo00Gooooo00?oo`00
o`000?ooool0A_ooool008oooooo00?o0000ooooooooool0?_ooool00ooo003oooooooooo`04oooo
o`03ool00?oooooooooo04Kooooo002?ooooo`03o`000?oooooooooo03kooooo00?oo`00oooooooo
ool01?ooool00ooo003oooooooooo`16ooooo`00Soooool2o`0003oooooo00?oo`00ooooooooool0
0oooool00ooo003o0000ooooo`17ooooo`00Soooool00ol0003oooooooooo`0nooooo`03ool00?oo
oooooooo00?ooooo00?oo`00o`000?ooool0Aoooool008oooooo00?o0000ooooooooool0?_ooool0
0ooo003oooooooooo`03ooooo`03ool00?l0003ooooo04Oooooo002?ooooo`03o`000?oooooooooo
03kooooo00?oo`00ooooooooool00oooool00ooo003o0000ooooo`17ooooo`00Soooool00ol0003o
ooooooooo`0nooooo`03ool00?oooooooooo00?ooooo00?oo`00o`000?ooool0Aoooool008oooooo
0_l0000oooooo`03ool00?oooooooooo00?ooooo00?oo`00o`000?ooool0Aoooool008oooooo00?o
0000ooooooooool0?_ooool00ol0003oo`00ooooo`03ooooo`03ool00?l0003ooooo04Oooooo001l
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000
ooooooooool0?_ooool00ol0003oo`00ooooo`03ooooo`03ool00?l0003ooooo04Oooooo001loooo
o`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo03kooooo00?o0000ool00?ooool00oooool00ooo003o0000ooooo`17ooooo`00OOooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0?_ooool00ol0
003oo`00ooooo`03ooooo`03ool00?l0003ooooo04Oooooo001mooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool00_ooool3o`0003kooooo00?o0000ool00?ooool00oooool00ooo003o
0000ooooo`17ooooo`00O_ooool00ol0003oooooooooo`05ooooo`Co00001Oooool00ol0003ooooo
ooooo`0nooooo`03o`000?oo003ooooo00?ooooo00?oo`00o`000?ooool0Aoooool007[ooooo00Go
0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
?_ooool00ol0003oo`00ooooo`02ooooo`03ool00?oooooo000004Sooooo001jooooo`Go00001ooo
ool5o`0000Cooooo00?o0000ooooooooool0?_ooool00ol0003oo`00ooooo`02ooooo`03ool00?oo
oooo000004Sooooo002?ooooo`;o0000?oooool00ol0003oo`00ooooo`02ooooo`03ool00?oooooo
000004Sooooo002?ooooo`03o`000?oooooooooo03kooooo00?o0000ool00?ooool00_ooool00ooo
003oooooo`000018ooooo`00Soooool00ol0003oooooooooo`0nooooo`03o`000?oo003ooooo00;o
oooo00?oo`00ooooool00000B?ooool008oooooo00?o0000ooooooooool0?_ooool00ol0003oo`00
ooooo`02ooooo`03ool00?oooooo000004Sooooo002?ooooo`03o`000?oooooooooo03kooooo00?o
0000ool00?ooool00_ooool00ooo003oooooo`000018ooooo`00Soooool2o`0003oooooo00?o0000
oooooooo00000_ooool00ooo003oooooo`000018ooooo`00Soooool00ol0003oooooooooo`0noooo
o`03o`000?ooooooo`0000;ooooo00?oo`00ooooool00000B?ooool008oooooo00?o0000oooooooo
ool0?_ooool00ol0003oooooool00002ooooo`03ool00?oooooo000004Sooooo002?ooooo`03o`00
0?oooooooooo03oooooo00Ko0000ool00?ooooooooooool00?l00019ooooo`00Soooool2o`00043o
oooo00Ko0000ool00?ooooooooooool00?l00019ooooo`00Soooool00ol0003oooooooooo`0ooooo
o`06o`000?ooooooo`00ool00?oooooo0000BOooool008oooooo00?o0000ooooooooool0?oooool0
1_l0003oooooool00?oo003oooooo`0004Wooooo002?ooooo`03o`000?oooooooooo03oooooo00Ko
0000oooooooo003oo`00ooooool00019ooooo`00Soooool00ol0003oooooooooo`0oooooo`06o`00
0?ooooooo`00ool00?oooooo0000BOooool008oooooo0_l00010ooooo`06o`000?ooooooo`00ool0
0?oooooo0000BOooool008oooooo00?o0000ooooooooool0?oooool01_l0003oooooool00?oo003o
ooooo`0004Wooooo0021ooooo`?o00001?ooool2o`0000Gooooo00?o0000ooooooooool0?oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Oooooo0022ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0oooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0Aoooool008;ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`17ooooo`00P_ooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooo
o`0000Cooooo0ol0000oooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Aoooool0
08;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooo
oooo03oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`17ooooo`00POooool2o`00
00Cooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0oooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0Aoooool008;ooooo00?o0000ooooooooool00oooool2o`00
00Gooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
04Oooooo002?ooooo`;o0000@?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Oo
oooo002?ooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`17ooooo`00Soooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0Aoooool008oooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo04Oooooo002?ooooo`03o`000?oooooooooo03oooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`17ooooo`00Soooool2o`00043ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`17ooooo`00Soooool00ol0003oooooooooo`0oooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0Aoooool008oooooo00?o0000ooooooooool0?ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Oooooo002?ooooo`03o`000?oooooo
oooo03oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`17ooooo`00Soooool2o`00
047ooooo00Go0000ooooooooooooooooo`000019ooooo`00Soooool00ol0003oooooooooo`10oooo
o`05o`000?ooooooooooooooool00000BOooool008oooooo00?o0000ooooooooool0@?ooool01Ol0
003ooooooooooooooooo000004Wooooo002?ooooo`03o`000?oooooooooo043ooooo00Go0000oooo
ooooooooooooo`000019ooooo`00Soooool00ol0003oooooooooo`10ooooo`05o`000?oooooooooo
ooooool00000BOooool008oooooo0_l00011ooooo`05o`000?ooooooooooooooool00000BOooool0
08oooooo00?o0000ooooooooool0@?ooool01Ol0003ooooooooooooooooo000004Wooooo001eoooo
o`?o00000_ooool5o`0000?ooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000oooo
ooooool0@?ooool01Ol0003ooooooooooooooooo000004Wooooo001fooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool0@?ooool01Ol0003ooooooooooooooooo000004Wooooo001fooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`?o0000@?oo
ool01?l0003oooooooooool0001:ooooo`00M_ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`10ooooo`04o`000?oo
ooooooooo`0004[ooooo001fooooo`05o`000?ooooooooooooooool000000oooool00ol0003ooooo
ooooo`05ooooo`Co00001Oooool00ol0003oooooooooo`10ooooo`04o`000?ooooooooooo`0004[o
oooo001eooooo`;o00000oooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`10ooooo`04o`000?ooooooooooo`0004[ooooo001fooooo`03
o`000?oooooooooo00;ooooo0ol00008ooooo`Go00001?ooool00ol0003oooooooooo`10ooooo`04
o`000?ooooooooooo`0004[ooooo002?ooooo`;o0000@Oooool01?l0003oooooooooool0001:oooo
o`00Soooool00ol0003oooooooooo`10ooooo`04o`000?ooooooooooo`0004[ooooo002?ooooo`03
o`000?oooooooooo043ooooo00Co0000oooooooooooo0000B_ooool008oooooo00?o0000oooooooo
ool0@?ooool01?l0003oooooooooool0001:ooooo`00Soooool00ol0003oooooooooo`11ooooo`03
o`000?oooooo000004[ooooo002?ooooo`;o0000@_ooool00ol0003oooooo`00001:ooooo`00Sooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooo000004[ooooo002?ooooo`03o`000?oooooo
oooo047ooooo00?o0000ooooool00000B_ooool008oooooo00?o0000ooooooooool0@Oooool00ol0
003oooooo`00001:ooooo`00Soooool2o`0004;ooooo00?o0000ooooool00000B_ooool008oooooo
00?o0000ooooooooool0@Oooool00ol0003oooooo`00001:ooooo`00Soooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooo000004[ooooo002?ooooo`03o`000?oooooooooo047ooooo00?o0000
ooooool00000B_ooool008oooooo00?o0000ooooooooool0@Oooool00ol0003oooooo`00001:oooo
o`00Soooool2o`0004;ooooo00?o0000ooooool00000B_ooool008oooooo00?o0000ooooooooool0
@Oooool00ol0003oooooo`00001:ooooo`00POooool3o`0000?ooooo0ol00005ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooool00000B_ooool008;ooooo00Go0000ooooooooooooooooo`00
0003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0@Oooool00ol0003oooooo`00
001:ooooo`00P_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo0ol00011
ooooo`03o`000?oooooo000004[ooooo0022ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`11ooooo`03o`000?oooooo000004[ooooo0022ooooo`04
o`000?ooooooooooooooo`Co00001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo0000
04[ooooo0021ooooo`;o00000oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo047o
oooo00?o0000ooooool00000B_ooool008;ooooo00Co0000oooooooooooooooo1Ol00004ooooo`03
o`000?oooooooooo04;ooooo00?o0000ooooooooool0BOooool008oooooo0_l00013ooooo`03o`00
0?oooooooooo04Wooooo002?ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0BOoo
ool008oooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`19ooooo`00Soooool00ol0
003oooooooooo`12ooooo`03o`000?oooooooooo04Wooooo002?ooooo`;o0000@oooool00ol0003o
ooooooooo`19ooooo`00Soooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo04Wooooo
002?ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0BOooool008oooooo00?o0000
ooooooooool0@_ooool00ol0003oooooooooo`19ooooo`00Soooool00ol0003oooooooooo`12oooo
o`03o`000?oooooooooo04Wooooo002?ooooo`;o0000Soooool008oooooo00?o0000ooooooooool0
S_ooool008oooooo00?o0000ooooooooool0S_ooool008oooooo00?o0000ooooooooool0S_ooool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.526251, -2.45249, \
0.00366045, 0.109267}}]
}, Open  ]],

Cell[TextData[{
  "where the red line is the result of nfftTranspose.  It should be noted in \
general that the transposed NFFT is not the inverse of the NFFT unlike the \
relationship of the discrete Fourier transform and inverse discrete Fourier \
transform.  This is because when viewed as a matrix multiplication, the \
matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Bold"], TraditionalForm]]],
  " of the nonequispaced Fourier transform is rectangular and thus the \
expression ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            SuperscriptBox["A", 
              StyleBox["T",
                FontWeight->"Plain"]],
            FontWeight->"Bold"], " ", "f"}], TraditionalForm]]],
  "is generally over or underdetermined.  A strategy for computing inverse \
nonequispaced Fourier transforms is discussed in [3] but not implemented in \
the current ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package.\n\nFor the sake of comparison a version of the transposed NFFT \
which does not use an approximation scheme is also implemented as \
ndftTranspose, the difference between the approximation and explicit \
calculation for the transposed NFFT example can be computed as follows:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[
      Total[\(#\ Conjugate[#] &\)[
          result - 
            ndftTranspose[data, Transpose[{\[Nu]}], {512}]]]]\)], "Input"],

Cell[BoxData[
    \(2.1995360829844102`*^-10 + 0.`\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Approximation Windows", "Section"],

Cell[TextData[{
  "nfft and nfftTranspose are both approximate routines.  The approximation \
itself is accomplished by using a window function which is localized in both \
the time and frequency domains [1].  The quality of the approximation is \
determined by the options to nfft and nfftTranspose: approximationWidth, \
oversamplingFactor, precomputed\[Psi], and precomputedc.  approximationWidth \
and oversamplingFactor control the truncation in the time domain of the \
window function and amount of oversampling in the time domain used to compute \
the NFFT.  The precomputed\[Psi] and precomputedc contain lists representing \
the value of the window function in the time and frequency domain at the \
appropriate nodes.  They are best computed using the precompute\[Psi] and \
precomputec functions.\n\nprecomputed\[Psi] contains the values of the window \
function \[Psi] evaluated at the nodes ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j - l\/n\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Nu]\_j - m \[LessEqual] l \[LessEqual] 
        n\ \[Nu]\_j + m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`Max[Dimensions[data]*oversamplingFactor, 
        2*m + 2]\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " is the approximation width.  precomputed\[Psi] also contains the bounds \
on ",
  Cell[BoxData[
      \(TraditionalForm\`l\)]],
  " for each ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_j\)]],
  ".  precomputedc contains the value of the Fourier transform of \[Psi] \
evaluated at nodes ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[LeftFloor]\(-N\)\/2\[RightFloor] ... \) \
\[LeftFloor]N\/2\[RightFloor]\)]],
  ".  The functions precompute\[Psi] and precomputec can be used to compute \
appropriate lists as follows where the utility function precomputen is used \
to determine the size of the oversampled data set as follows:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(nfftTranspose[data, Transpose[{\[Nu]}], {512}, 
        precomputed\[Psi] -> 
          precompute\[Psi][Transpose[{\[Nu]}], precomputen[{512}]], 
        precomputedc \[Rule] precomputec[precomputen[{512}]]];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), "\<\"Infinite expression \
\\!\\(1\\/0\\) encountered. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Power::infy\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(\[Infinity]::"indet"\), \(\(:\)\(\ \)\), "\<\"Indeterminate \
expression \\!\\(0\\\\ ComplexInfinity\\) encountered. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::indet\\\"]\\)\"\>"}]], \
"Message"]
}, Open  ]],

Cell["\<\
The window functions used in the approximation can be overriden \
with the windowFunction and windowFunctionTransformed options of precompute\
\[Psi] and precomputec.  The windowFunction is expressed as a function of \
\[Nu], the size of the approximation grid, half the width of the \
approximation grid minus one, and the oversampling factor.  \
windowFunctionTransformed is a function of the index k, the size of the \
approximation grid, half the width of the approximation grid minus one, and \
the oversampling factor.  For example to use a Guassian window function, \
define\
\>", "Text"],

Cell[BoxData[{
    \(gaussian[\[Nu]_, n_, m_, \[Alpha]_] := 
      With[{b = \(2\ \[Alpha]\ m\)\/\(\[Pi]\ \((2\ \[Alpha] - 1)\)\)}, 
        Exp[\(-\((n\ \[Nu])\)\^2\)\/b]\/\@\(\[Pi]\ b\)]\), "\
\[IndentingNewLine]", 
    \(gaussianTransformed[k_, n_, m_, \[Alpha]_] := 
      With[{b = \(2\ \[Alpha]\ m\)\/\(\[Pi]\ \((2\ \[Alpha] - 1)\)\)}, 
        Exp[\(-\((\(\[Pi]\ k\)\/n)\)\^2\)\ b]]\)}], "Input"],

Cell["\<\
This difference between using this window and the default for the \
same window width and oversampling rate can be computed as:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(result2 = 
        nfftTranspose[data, Transpose[{\[Nu]}], {512}, 
          precomputed\[Psi] -> 
            precompute\[Psi][Transpose[{\[Nu]}], precomputen[{512}], 
              windowFunction \[Rule] gaussian], 
          precomputedc \[Rule] 
            precomputec[precomputen[{512}], 
              windowFunctionTransformed \[Rule] 
                gaussianTransformed]];\)\), "\[IndentingNewLine]", 
    \(\(ListPlot[
        Transpose[{Range[\(-256\), 255]\/512, Re[result - result2]}], 
        PlotJoined \[Rule] True, 
        PlotRange \[Rule] All];\)\), "\[IndentingNewLine]", 
    \(With[{x = result - result2}, Sqrt[x . Conjugate[x]]]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500932 0.954245 0.412489 76377.2 [
[.11923 .39999 -12 -9 ]
[.11923 .39999 12 0 ]
[.31008 .39999 -12 -9 ]
[.31008 .39999 12 0 ]
[.69178 .39999 -9 -9 ]
[.69178 .39999 9 0 ]
[.88263 .39999 -9 -9 ]
[.88263 .39999 9 0 ]
[.48843 .10698 -39 -6.25 ]
[.48843 .10698 0 6.25 ]
[.48843 .25973 -39 -6.25 ]
[.48843 .25973 0 6.25 ]
[.48843 .56524 -33 -6.25 ]
[.48843 .56524 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11923 .41249 m
.11923 .41874 L
s
[(-0.4)] .11923 .39999 0 1 Mshowa
.31008 .41249 m
.31008 .41874 L
s
[(-0.2)] .31008 .39999 0 1 Mshowa
.69178 .41249 m
.69178 .41874 L
s
[(0.2)] .69178 .39999 0 1 Mshowa
.88263 .41249 m
.88263 .41874 L
s
[(0.4)] .88263 .39999 0 1 Mshowa
.125 Mabswid
.16695 .41249 m
.16695 .41624 L
s
.21466 .41249 m
.21466 .41624 L
s
.26237 .41249 m
.26237 .41624 L
s
.3578 .41249 m
.3578 .41624 L
s
.40551 .41249 m
.40551 .41624 L
s
.45322 .41249 m
.45322 .41624 L
s
.54864 .41249 m
.54864 .41624 L
s
.59636 .41249 m
.59636 .41624 L
s
.64407 .41249 m
.64407 .41624 L
s
.73949 .41249 m
.73949 .41624 L
s
.78721 .41249 m
.78721 .41624 L
s
.83492 .41249 m
.83492 .41624 L
s
.07152 .41249 m
.07152 .41624 L
s
.02381 .41249 m
.02381 .41624 L
s
.93034 .41249 m
.93034 .41624 L
s
.97805 .41249 m
.97805 .41624 L
s
.25 Mabswid
0 .41249 m
1 .41249 L
s
.50093 .10698 m
.50718 .10698 L
s
gsave
.48843 .10698 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.50093 .25973 m
.50718 .25973 L
s
gsave
.48843 .25973 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.50093 .56524 m
.50718 .56524 L
s
gsave
.48843 .56524 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.125 Mabswid
.50093 .14517 m
.50468 .14517 L
s
.50093 .18336 m
.50468 .18336 L
s
.50093 .22155 m
.50468 .22155 L
s
.50093 .29792 m
.50468 .29792 L
s
.50093 .33611 m
.50468 .33611 L
s
.50093 .3743 m
.50468 .3743 L
s
.50093 .45068 m
.50468 .45068 L
s
.50093 .48887 m
.50468 .48887 L
s
.50093 .52706 m
.50468 .52706 L
s
.50093 .06879 m
.50468 .06879 L
s
.50093 .0306 m
.50468 .0306 L
s
.50093 .60343 m
.50468 .60343 L
s
.25 Mabswid
.50093 0 m
.50093 .61803 L
s
.5 Mabswid
.02381 .11403 m
.02567 .1398 L
.02754 .1909 L
.0294 .25909 L
.03126 .33328 L
.03313 .40311 L
.03499 .46212 L
.03686 .50905 L
.03872 .54584 L
.04058 .57422 L
.04245 .59385 L
.04431 .60332 L
.04617 .60237 L
.04804 .59331 L
.0499 .58021 L
.05177 .56646 L
.05363 .55338 L
.05549 .54099 L
.05736 .52927 L
.05922 .51853 L
.06108 .50887 L
.06295 .49951 L
.06481 .48876 L
.06668 .47503 L
.06854 .4578 L
.0704 .43738 L
.07227 .41446 L
.07413 .39033 L
.07599 .3673 L
.07786 .34778 L
.07972 .3329 L
.08159 .32223 L
.08345 .31494 L
.08531 .31061 L
.08718 .30927 L
.08904 .31091 L
.0909 .31506 L
.09277 .32086 L
.09463 .32717 L
.0965 .33301 L
.09836 .33808 L
.10022 .34289 L
.10209 .3484 L
.10395 .35531 L
.10581 .36353 L
.10768 .37209 L
.10954 .37958 L
.11141 .38474 L
.11327 .38691 L
.11513 .38616 L
Mistroke
.117 .38313 L
.11886 .37879 L
.12073 .37419 L
.12259 .37034 L
.12445 .36799 L
.12632 .36749 L
.12818 .36873 L
.13004 .37126 L
.13191 .37445 L
.13377 .37789 L
.13564 .38144 L
.1375 .38517 L
.13936 .38911 L
.14123 .39312 L
.14309 .39692 L
.14495 .40019 L
.14682 .40282 L
.14868 .40492 L
.15055 .40668 L
.15241 .40821 L
.15427 .40956 L
.15614 .41075 L
.158 .41183 L
.15986 .41291 L
.16173 .41412 L
.16359 .41549 L
.16546 .41693 L
.16732 .41834 L
.16918 .41961 L
.17105 .42068 L
.17291 .42141 L
.17477 .42169 L
.17664 .42153 L
.1785 .42106 L
.18037 .42042 L
.18223 .41972 L
.18409 .41895 L
.18596 .41812 L
.18782 .41725 L
.18968 .41638 L
.19155 .41558 L
.19341 .4149 L
.19528 .41438 L
.19714 .41401 L
.199 .4137 L
.20087 .41338 L
.20273 .41301 L
.20459 .41257 L
.20646 .41215 L
.20832 .41182 L
Mistroke
.21019 .41167 L
.21205 .41173 L
.21391 .41198 L
.21578 .41236 L
.21764 .41281 L
.2195 .41323 L
.22137 .41357 L
.22323 .41378 L
.2251 .41384 L
.22696 .41375 L
.22882 .41354 L
.23069 .41325 L
.23255 .41295 L
.23441 .41265 L
.23628 .41239 L
.23814 .41216 L
.24001 .41193 L
.24187 .41171 L
.24373 .4115 L
.2456 .41133 L
.24746 .4112 L
.24932 .41113 L
.25119 .41109 L
.25305 .41107 L
.25492 .41107 L
.25678 .41107 L
.25864 .41108 L
.26051 .4111 L
.26237 .41113 L
.26423 .41116 L
.2661 .41119 L
.26796 .41121 L
.26983 .41123 L
.27169 .41125 L
.27355 .41129 L
.27542 .41133 L
.27728 .41138 L
.27914 .41145 L
.28101 .41153 L
.28287 .41163 L
.28474 .41173 L
.2866 .41183 L
.28846 .4119 L
.29033 .41197 L
.29219 .41203 L
.29405 .41209 L
.29592 .41214 L
.29778 .41219 L
.29965 .41223 L
.30151 .41226 L
Mistroke
.30337 .41228 L
.30524 .41229 L
.3071 .41231 L
.30896 .41233 L
.31083 .41235 L
.31269 .41239 L
.31456 .41242 L
.31642 .41245 L
.31828 .41246 L
.32015 .41245 L
.32201 .41243 L
.32387 .41238 L
.32574 .41233 L
.3276 .41228 L
.32947 .41223 L
.33133 .41218 L
.33319 .41215 L
.33506 .41212 L
.33692 .41211 L
.33878 .41211 L
.34065 .41212 L
.34251 .41215 L
.34438 .41218 L
.34624 .41222 L
.3481 .41226 L
.34997 .4123 L
.35183 .41234 L
.35369 .41238 L
.35556 .41242 L
.35742 .41246 L
.35929 .41249 L
.36115 .41252 L
.36301 .41253 L
.36488 .41254 L
.36674 .41254 L
.3686 .41254 L
.37047 .41253 L
.37233 .41251 L
.3742 .4125 L
.37606 .41248 L
.37792 .41247 L
.37979 .41246 L
.38165 .41246 L
.38352 .41246 L
.38538 .41247 L
.38724 .41249 L
.38911 .4125 L
.39097 .41252 L
.39283 .41254 L
.3947 .41255 L
Mistroke
.39656 .41257 L
.39843 .41258 L
.40029 .41259 L
.40215 .41259 L
.40402 .41258 L
.40588 .41257 L
.40774 .41256 L
.40961 .41255 L
.41147 .41253 L
.41334 .41252 L
.4152 .4125 L
.41706 .41249 L
.41893 .41249 L
.42079 .41248 L
.42265 .41249 L
.42452 .41249 L
.42638 .41251 L
.42825 .41252 L
.43011 .41254 L
.43197 .41257 L
.43384 .41259 L
.4357 .41262 L
.43756 .41264 L
.43943 .41265 L
.44129 .41267 L
.44316 .41267 L
.44502 .41267 L
.44688 .41267 L
.44875 .41266 L
.45061 .41266 L
.45247 .41265 L
.45434 .41264 L
.4562 .41263 L
.45807 .41262 L
.45993 .41262 L
.46179 .41261 L
.46366 .41261 L
.46552 .41261 L
.46738 .41261 L
.46925 .41261 L
.47111 .41261 L
.47298 .41262 L
.47484 .41262 L
.4767 .41263 L
.47857 .41264 L
.48043 .41265 L
.48229 .41265 L
.48416 .41265 L
.48602 .41265 L
.48789 .41264 L
Mistroke
.48975 .41263 L
.49161 .41262 L
.49348 .41261 L
.49534 .4126 L
.4972 .41259 L
.49907 .41259 L
.50093 .41259 L
.5028 .41259 L
.50466 .4126 L
.50652 .4126 L
.50839 .41261 L
.51025 .41261 L
.51211 .41261 L
.51398 .41261 L
.51584 .41261 L
.51771 .41261 L
.51957 .41261 L
.52143 .41261 L
.5233 .4126 L
.52516 .4126 L
.52702 .41259 L
.52889 .41259 L
.53075 .41258 L
.53262 .41257 L
.53448 .41256 L
.53634 .41255 L
.53821 .41254 L
.54007 .41253 L
.54193 .41251 L
.5438 .41251 L
.54566 .4125 L
.54753 .4125 L
.54939 .41249 L
.55125 .41248 L
.55312 .41247 L
.55498 .41245 L
.55684 .41244 L
.55871 .41243 L
.56057 .41242 L
.56244 .41241 L
.5643 .41241 L
.56616 .4124 L
.56803 .4124 L
.56989 .41239 L
.57175 .41239 L
.57362 .41239 L
.57548 .41239 L
.57735 .41239 L
.57921 .41238 L
.58107 .41238 L
Mistroke
.58294 .41237 L
.5848 .41236 L
.58666 .41236 L
.58853 .41235 L
.59039 .41234 L
.59226 .41233 L
.59412 .41232 L
.59598 .41231 L
.59785 .4123 L
.59971 .4123 L
.60157 .4123 L
.60344 .4123 L
.6053 .4123 L
.60717 .41231 L
.60903 .41232 L
.61089 .41233 L
.61276 .41234 L
.61462 .41236 L
.61648 .41238 L
.61835 .4124 L
.62021 .41241 L
.62208 .41242 L
.62394 .41243 L
.6258 .41243 L
.62767 .41242 L
.62953 .41241 L
.6314 .4124 L
.63326 .41239 L
.63512 .41237 L
.63699 .41236 L
.63885 .41236 L
.64071 .41236 L
.64258 .41236 L
.64444 .41237 L
.64631 .41239 L
.64817 .4124 L
.65003 .41241 L
.6519 .41242 L
.65376 .41243 L
.65562 .41244 L
.65749 .41244 L
.65935 .41243 L
.66122 .41242 L
.66308 .41241 L
.66494 .41239 L
.66681 .41237 L
.66867 .41235 L
.67053 .41232 L
.6724 .41228 L
.67426 .41223 L
Mistroke
.67613 .41217 L
.67799 .41211 L
.67985 .41206 L
.68172 .41202 L
.68358 .412 L
.68544 .412 L
.68731 .412 L
.68917 .412 L
.69104 .41202 L
.6929 .41204 L
.69476 .41208 L
.69663 .41212 L
.69849 .41216 L
.70035 .41219 L
.70222 .41221 L
.70408 .41222 L
.70595 .41222 L
.70781 .41222 L
.70967 .41221 L
.71154 .4122 L
.7134 .41219 L
.71526 .41217 L
.71713 .41215 L
.71899 .41211 L
.72086 .41206 L
.72272 .41199 L
.72458 .41191 L
.72645 .41184 L
.72831 .41179 L
.73017 .41175 L
.73204 .41174 L
.7339 .41173 L
.73577 .41171 L
.73763 .41168 L
.73949 .41161 L
.74136 .4115 L
.74322 .41136 L
.74508 .41121 L
.74695 .41108 L
.74881 .411 L
.75068 .41097 L
.75254 .411 L
.7544 .4111 L
.75627 .41126 L
.75813 .41147 L
.75999 .41172 L
.76186 .412 L
.76372 .41229 L
.76559 .41257 L
.76745 .41281 L
Mistroke
.76931 .41298 L
.77118 .41305 L
.77304 .413 L
.7749 .41282 L
.77677 .41253 L
.77863 .41214 L
.7805 .41171 L
.78236 .4113 L
.78422 .41097 L
.78609 .41073 L
.78795 .41058 L
.78981 .41051 L
.79168 .41045 L
.79354 .41034 L
.79541 .41012 L
.79727 .40975 L
.79913 .40924 L
.801 .40862 L
.80286 .4079 L
.80472 .40711 L
.80659 .40627 L
.80845 .40542 L
.81032 .40459 L
.81218 .40373 L
.81404 .40281 L
.81591 .40171 L
.81777 .40037 L
.81963 .39878 L
.8215 .39708 L
.82336 .39548 L
.82523 .39416 L
.82709 .39317 L
.82895 .39241 L
.83082 .39176 L
.83268 .39116 L
.83454 .39067 L
.83641 .39035 L
.83827 .3902 L
.84014 .39007 L
.842 .38977 L
.84386 .38913 L
.84573 .38813 L
.84759 .38687 L
.84945 .38544 L
.85132 .38392 L
.85318 .38232 L
.85505 .38061 L
.85691 .37867 L
.85877 .37629 L
.86064 .37329 L
Mistroke
.8625 .36978 L
.86436 .36614 L
.86623 .36286 L
.86809 .36029 L
.86996 .35854 L
.87182 .35744 L
.87368 .35665 L
.87555 .35582 L
.87741 .35468 L
.87927 .35324 L
.88114 .35189 L
.883 .35136 L
.88487 .35244 L
.88673 .35565 L
.88859 .36103 L
.89046 .36825 L
.89232 .37677 L
.89419 .38582 L
.89605 .39441 L
.89791 .40155 L
.89978 .40651 L
.90164 .40864 L
.9035 .40716 L
.90537 .40136 L
.90723 .39094 L
.9091 .3762 L
.91096 .35809 L
.91282 .33809 L
.91469 .31813 L
.91655 .30025 L
.91841 .28602 L
.92028 .27596 L
.92214 .26918 L
.92401 .26374 L
.92587 .25728 L
.92773 .24759 L
.9296 .23322 L
.93146 .21414 L
.93332 .19174 L
.93519 .16801 L
.93705 .14459 L
.93892 .12265 L
.94078 .10315 L
.94264 .08667 L
.94451 .07274 L
.94637 .05996 L
.94823 .04687 L
.9501 .03313 L
.95196 .0208 L
.95383 .01472 L
Mistroke
.95569 .02027 L
.95755 .03964 L
.95942 .06984 L
.96128 .10461 L
.96314 .13885 L
.96501 .1713 L
.96687 .20292 L
.96874 .23319 L
.9706 .2586 L
.97246 .2749 L
.97433 .2805 L
.97619 .27825 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oSoooool0
0ol0003oooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`00Soooool00ol0003o
ooooooooo`2>ooooo`00Soooool00ol0003oooooooooo`2>ooooo`00Soooool00ol0003ooooooooo
o`1oooooo`03o`000?oooooooooo00cooooo002?ooooo`03o`000?oooooooooo07oooooo00?o0000
ooooooooool03?ooool008oooooo00?o0000ooooooooool0O_ooool2o`0000kooooo002?ooooo`03
o`000?oooooooooo07kooooo0_l0000>ooooo`00Soooool2o`0007oooooo0_l0000>ooooo`00Sooo
ool00ol0003oooooooooo`1nooooo`03o`000?oooooo000000gooooo002?ooooo`03o`000?oooooo
oooo07kooooo00?o0000ooooool000003Oooool008oooooo00?o0000ooooooooool0O_ooool00ol0
003oooooo`00000=ooooo`00Soooool00ol0003oooooooooo`1mooooo`04o`000?ooooooooooo`00
00gooooo002?ooooo`03o`000?oooooooooo07gooooo00Co0000oooooooooooo00003Oooool008oo
oooo00?o0000ooooooooool0OOooool01?l0003oooooooooool0000=ooooo`00Soooool00ol0003o
ooooooooo`1mooooo`04o`000?ooooooooooo`0000gooooo002?ooooo`03o`000?oooooooooo07go
oooo00Go0000ooooooooooooooooo`00000<ooooo`00Soooool00ol0003oooooooooo`1mooooo`05
o`000?ooooooooooooooool000003?ooool008oooooo00?o0000ooooooooool0OOooool01Ol0003o
oooooooooooooooo000000cooooo002?ooooo`;o0000OOooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00[ooooo002?ooooo`03o`000?oooooooooo07cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0:ooooo`00Soooool00ol0003oooooooooo`1looooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool02_ooool008oooooo00?o0000ooooooooool0O?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo002?ooooo`03o`000?oooooooooo
07cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:ooooo`00Soooool00ol0003o
ooooooooo`1looooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02_ooool008oooooo
00?o0000ooooooooool0O?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo
002?ooooo`03o`000?oooooooooo07cooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0:ooooo`00KOooool3o`0000;ooooo00Go0000ooooooooooooooooo`000007ooooo`?o00001?oo
ool2o`0000Sooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00[ooooo001^ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000002Oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0Nooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo001Uooooo`Go000000?ooooo
o`000?l000000ol00004ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool0
1?l0003oooooooooool00007ooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0:ooooo`00Joooool01?l0003oooooooooool00004ooooo`03o`000?oo
oooo000000Wooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00007ooooo`?o0000
Noooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo001/ooooo`03o`000?oo
oooo000000?ooooo00Go0000ooooooooooooooooo`000008ooooo`03o`000?oooooooooo00;ooooo
00Co0000oooooooooooo00001oooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02_ooool000Oooooo00?o0000ooooooooool0Hoooool2o`0000oooooo
0_l00004ooooo`04o`000?ooooooooooo`0000Oooooo0ol0001kooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02_ooool000Oooooo00?o0000ooooooooool0I?ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00?ooooo0_l00003ooooo`Co000000Coooooo`000?oooooo
0000Noooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00[ooooo0007ooooo`03o`00
0?oooooooooo08Gooooo0ol0001kooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2_ooool000Oooooo00?o0000ooooooooool0QOooool00ol0003oooooooooo`1kooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000ooooooooool0QOooool3
o`0007_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`001oooool00ol0
003oooooooooo`25ooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo07_o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003ooooo
ooooo`25ooooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`09ooooo`001oooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo07[ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`25
ooooo`;o0000Noooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo0007oooo
o`03o`000?oooooooooo08Gooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oooooooooo08Gooooo00?o0000oooooooo
ool0N_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo0007ooooo`03o`00
0?oooooooooo08Gooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Wooooo0007ooooo`03o`000?oooooooooo08Gooooo00?o0000ooooooooool0N_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oooooo
oooo08Gooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Wooooo0007ooooo`03o`000?oooooooooo08Gooooo00?o0000ooooooooool0N_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo0008ooooo`03o`000?oooooooooo08Co
oooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wo
oooo0008ooooo`03o`000?oooooooooo08Cooooo00?o0000ooooooooool0N_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Wooooo0008ooooo`03o`000?oooooooooo08Cooooo00?o
0000ooooooooool0N_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo0008
ooooo`03o`000?oooooooooo08Cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Wooooo0008ooooo`03o`000?oooooooooo08Cooooo0_l0001joooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02Oooool000Sooooo00?o0000oooooooo
ool0Q?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool02Oooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003oooooooooo`1iooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02?ooool000Sooooo00?o0000ooooooooool0Q?oo
ool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0
003oooooooooo`1iooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool000So
oooo00?o0000ooooooooool0Q?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02?ooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003ooooo
ooooo`1iooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool000Sooooo00?o
0000ooooooooool0Q?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool02?ooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003oooooooooo`1i
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool000Sooooo00?o0000oooo
ooooool0Q?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool000Sooooo00?o0000ooooooooool0Q?ooool2o`0007[ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`08ooooo`002?ooool00ol0003oooooooooo`24ooooo`03o`00
0?oooooooooo07Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`002?oo
ool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`08ooooo`002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooo
oooo07Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`002?ooool00ol0
003oooooooooo`24ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`08ooooo`002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo07So
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`002?ooool00ol0003ooooo
ooooo`24ooooo`03o`000?oooooooooo07Oooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo07Oooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`002?ooool00ol0003oooooooooo`1P
ooooo`Go00000_ooool01Ol0003ooooooooooooooooo000000Oooooo0ol00004ooooo`;o00002?oo
ool00ol0003oooooooooo`1gooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01ooo
ool000Sooooo00?o0000ooooooooool0HOooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooo000000Wooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00007ooooo`03o`00
0?oooooooooo07Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`002?oo
ool00ol0003oooooooooo`1Jooooo`Go00000oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00007ooooo`03o`00
0?oooooooooo07Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`002?oo
ool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool000002Ooo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Oooooo0ol0001gooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool01oooool000Sooooo00?o0000ooooooooool0H?oo
ool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000008ooooo`03
o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`1foooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool000Sooooo00?o0000oooooooo
ool0H?ooool01Ol0003ooooooooooooooooo000000kooooo0_l00004ooooo`04o`000?oooooooooo
o`0000Oooooo0ol0001fooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool0
00Sooooo00?o0000ooooooooool0HOooool3o`00013ooooo00?o0000ooooooooool00oooool2o`00
00?ooooo1?l000001?oooooo0000ooooool0001fooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool01oooool000Sooooo00?o0000ooooooooool0Q?ooool3o`0007Kooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`07ooooo`002?ooool00ol0003oooooooooo`24ooooo`03
o`000?oooooooooo07Gooooo00?o0000ooooooooool03?ooool2o`0000Sooooo0008ooooo`03o`00
0?oooooooooo08Cooooo0ol0001eooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
1_ooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003oooooooooo`1eooooo`03o`000?oo
oooooooo01Kooooo0008ooooo`03o`000?oooooooooo08Cooooo00?o0000ooooooooool0MOooool0
0ol0003oooooooooo`0Fooooo`002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo
07Gooooo00?o0000ooooooooool05_ooool000Sooooo00?o0000ooooooooool0Q?ooool00ol0003o
ooooooooo`1dooooo`03o`000?oooooooooo01Oooooo0009ooooo`03o`000?oooooooooo08?ooooo
0_l0001eooooo`03o`000?oooooooooo01Oooooo0009ooooo`03o`000?oooooooooo08?ooooo00?o
0000ooooooooool0M?ooool00ol0003oooooooooo`0Gooooo`002Oooool00ol0003oooooooooo`23
ooooo`03o`000?oooooooooo07Cooooo00?o0000ooooooooool05oooool000Wooooo00?o0000oooo
ooooool03?ooool2o`0007Gooooo00?o0000ooooooooool0M?ooool00ol0003oooooooooo`0Goooo
o`002Oooool00ol0003oooooooooo`0<ooooo`;o0000MOooool00ol0003oooooooooo`1dooooo`03
o`000?oooooooooo01Oooooo0009ooooo`03o`000?oooooooooo00cooooo00?o0000ooooool00000
M?ooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo01Oooooo0009ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooool00000M?ooool00ol0003oooooooooo`1dooooo`03o`000?oo
oooooooo01Oooooo0009ooooo`03o`000?oooooooooo00_ooooo00Co0000oooooooooooo0000M?oo
ool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo01Oooooo0009ooooo`03o`000?oooooo
oooo00_ooooo00Go0000ooooooooooooooooo`00001cooooo`03o`000?oooooooooo07Cooooo00?o
0000ooooooooool05oooool000Wooooo00?o0000ooooooooool02oooool01Ol0003ooooooooooooo
oooo000007?ooooo00?o0000ooooooooool0Loooool00ol0003oooooooooo`0Hooooo`002Oooool0
0ol0003oooooooooo`0;ooooo`05o`000?ooooooooooooooool00000Loooool00ol0003ooooooooo
o`1cooooo`03o`000?oooooooooo01Sooooo0009ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`1`ooooo`;o0000M?ooool00ol0003oooooooooo`0H
ooooo`002Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0L?ooool00ol0003oooooooooo`1cooooo`03o`000?oooooooooo01Sooooo0009ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1_ooooo`03
o`000?oooooooooo07?ooooo00?o0000ooooooooool06?ooool000Wooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool0
Loooool00ol0003oooooooooo`0Hooooo`002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`1Zooooo`;o00001ooo
ool00ol0003oooooooooo`0Hooooo`002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`1Yooooo`;o000000?ooooo
o`000?ooool01Oooool00ol0003oooooooooo`0Hooooo`002Oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`1Woooo
o`;o00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Sooooo0009ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1^ooooo`03
o`000?oooooooooo06Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01Sooooo0009ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Sooooo0009ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`?o0000JOoo
ool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0Iooooo`002Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Gooooo0_l00003ooooo`?o00001?ooool3o`0002Sooooo0_l00004ooooo`04o`000?oooooo
ooooooooo`Go0000:oooool00ol0003oooooooooo`0]ooooo`;o00001?ooool01?l0003ooooooooo
ooooool5o`0002Sooooo0_l00004ooooo`04o`000?ooooooooooo`0000;ooooo0ol0000Kooooo`00
2Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00Ko0000ooooool0003o
0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool09_ooool01?l0
003oooooooooool00008ooooo`04o`000?ooooooooooo`0002_ooooo0_l0000]ooooo`04o`000?oo
ooooooooo`0000Sooooo00Co0000oooooooooooo00009oooool2o`000003ooooool0003ooooo00Go
oooo00Co0000oooooooooooooooo0_l0000Kooooo`002Oooool00ol0003oooooooooo`0:ooooo`Go
00000_ooool01_l0003oooooo`000?l0003oooooo`0000?ooooo00?o0000ooooool000001?l0000P
ooooo`Go00000_ooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo02_ooooo00?o
0000ooooooooool0;?ooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo02Oooooo
00Co0000oooooooooooo00001_ooool6o`0001_ooooo0009ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01Oooool00ol0003oooooo`000002o`0000Gooooo0_l00002ooooo`03o`00
0?oooooooooo02Kooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0Zooooo`03
o`000?oooooooooo02cooooo00Co0000oooooooooooo00002_ooool00ol0003oooooooooo`0Uoooo
o`;o00000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;o00006oooool000Wo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;o
00001Oooool01Ol0003oooooo`000?oooooo000002Sooooo00Co0000oooooooooooo00001oooool0
1Ol0003ooooooooooooooooo000002_ooooo00?o0000ooooooooool0;?ooool01?l0003ooooooooo
ool00007ooooo`05o`000?ooooooooooooooool000009Oooool00ol0003oooooo`000002ooooo`03
o`000?oooooooooo00Gooooo0_l000000ooooooo0000o`00000Kooooo`002Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00001oooool01?l0003o
ooooo`000?l0000Xooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00
000[ooooo`03o`000?oooooooooo02cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooo
oooooooooooo0000027ooooo1?l00002ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ool000000_l0000Kooooo`002Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Ko
oooo0_l00008ooooo`04o`000?ooooooooooo`0002Wooooo0_l00009ooooo`?o0000;?ooool00ol0
003oooooooooo`0]ooooo`;o00002Oooool3o`0001oooooo0ol00007ooooo`;o00002?ooool00ol0
003oooooooooo`02o`0001_ooooo0009ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo05Wooooo0_l0000Cooooo`04
o`000?ooooooooooo`0001cooooo0009ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo05Sooooo0_l0000Eooooo`03
o`000?oooooo000001cooooo0009ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`1Rooooo`03o`000?oooooooooo05Kooooo0_l0000Gooooo`03o`00
0?oooooo000001cooooo0009ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo05Cooooo0_l0000Iooooo`03o`000?oo
oooo000001cooooo0009ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool05?ooool2
o`0000gooooo0ol00007ooooo`ko0000??ooool00ol0003oooooooooo`0mooooo`_o00001Oooool7
o`0001cooooo00?o0000ooooooooool06oooool00?oo00008?l00001ooooo`001oooool00ol0003o
ooooo`00000:ooooo`;o00003?ooool00ol0003oooooooooo`0:ooooo`;o00001?ooool3o`0000Go
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`05ooooo`002Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo01Sooooo1_l0001Iooooo`03o`000?oooooooooo08kooooo
0009ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0Moooool00ol0003ooooooooo
o`2>ooooo`002Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo07Sooooo00?o0000
ooooooooool0S_ooool000Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1hoooo
o`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool0N?ooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo07Sooooo00?o0000ooooooooool0S_ooool000[ooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0N?ooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool0S_ooool000[o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1iooooo`;o0000Soooool000[ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo08kooooo
000:ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0NOooool00ol0003ooooooooo
o`2>ooooo`002_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo07Wooooo00?o0000
ooooooooool0S_ooool000[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1ioooo
o`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0NOooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo07Wooooo00?o0000ooooooooool0S_ooool000[ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0NOooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo07[ooooo00?o0000ooooooooool0S_ooool000[o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo08ko
oooo000:ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0N_ooool2o`0008oooooo
000:ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0N_ooool00ol0003ooooooooo
o`2>ooooo`002_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo07[ooooo00?o0000
ooooooooool0S_ooool000[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1joooo
o`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0N_ooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo07_ooooo00?o0000ooooooooool0S_ooool000[ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo08kooooo000:ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool0Noooool00ol0003oooooooooo`2>ooooo`002_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo07_ooooo00?o0000ooooooooool0S_ooool000[o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1kooooo`03o`000?oooooooooo08ko
oooo000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0O?ooool2o`0008oooooo
000;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0O?ooool00ol0003ooooooooo
o`2>ooooo`002oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo07cooooo00?o0000
ooooooooool0S_ooool000_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1loooo
o`03o`000?oooooooooo08kooooo000;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0O?ooool00ol0003oooooooooo`2>ooooo`002oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo07cooooo00?o0000ooooooooool0S_ooool000_ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`1looooo`03o`000?oooooooooo08kooooo000;ooooo`05o`000?oooooo
ooooooooool00000Ooooool00ol0003oooooooooo`2>ooooo`002oooool01Ol0003ooooooooooooo
oooo000005_ooooo1Ol00002ooooo`05o`000?ooooooooooooooool000001oooool3o`0000Cooooo
0_l00008ooooo`03o`000?oooooooooo08kooooo000;ooooo`05o`000?ooooooooooooooool00000
G?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000Wooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo08kooooo000;ooooo`05
o`000?ooooooooooooooool00000GOooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooo
oooo08kooooo000;ooooo`05o`000?ooooooooooooooool00000G_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0
0007ooooo`?o0000S_ooool000_ooooo00Go0000ooooooooooooooooo`00001Kooooo`05o`000?oo
ooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Sooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo08kooooo000;ooooo`05
o`000?ooooooooooooooool00000Foooool01Ol0003ooooooooooooooooo000000kooooo0_l00004
ooooo`04o`000?ooooooooooo`0000Oooooo0ol0002>ooooo`002oooool01Ol0003ooooooooooooo
oooo000005cooooo0ol0000@ooooo`03o`000?oooooooooo00?ooooo0_l00003ooooo`Co000000Co
ooooo`000?oooooo0000S_ooool000_ooooo00Co0000oooooooooooo0000P?ooool3o`0008kooooo
000;ooooo`04o`000?ooooooooooo`00083ooooo00?o0000ooooooooool0S_ooool000_ooooo00Co
0000oooooooooooo0000P?ooool3o`0008kooooo000<ooooo`03o`000?oooooo0000083ooooo00?o
0000ooooooooool0S_ooool000cooooo00?o0000ooooool00000P?ooool00ol0003oooooooooo`2>
ooooo`003?ooool00ol0003oooooo`000020ooooo`03o`000?oooooooooo08kooooo000<ooooo`;o
0000POooool00ol0003oooooooooo`2>ooooo`003Oooool00ol0003oooooooooo`1oooooo`;o0000
Soooool008oooooo00?o0000ooooooooool0S_ooool008oooooo00?o0000ooooooooool0S_ooool0
08oooooo00?o0000ooooooooool0S_ooool008oooooo00?o0000ooooooooool0S_ooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.526251, -5.40072*^-6, \
0.00366045, 4.57331*^-8}}],

Cell[BoxData[
    \(\(\(0.00004336117741341868`\)\(\[InvisibleSpace]\)\) + 
      1.0016825989447389`*^-22\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bibliography", "Section"],

Cell["\<\
[1] D. Potts,  G. Steidl, and  M. Tasche, \"Fast Fourier transforms \
for nonequispaced data: A tutorial\" in Modern Sampling Theory: Mathematics \
and Applications, J.J. Benedetto and P. Ferreira (Eds.), Chapter 12, pages \
249-274.\
\>", "Text"],

Cell["\<\
[2] V.A.Mandelshtam,The Multidimensional Filter Diagonalization \
Method,I.Theory and Numerical Implementation,J.Mag.Res.144 (2000) \
343-356.\
\>", "Text"],

Cell["\<\
[3] S. Kunis and D. Potts.Stability results for scattered data \
interpolation by trigonometric polynomials.  Preprint, Univ. \
L\[UDoubleDot]beck, A-04-12, 2004.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1600}, {0, 1174}},
WindowSize->{520, 740},
WindowMargins->{{4, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 48, 0, 136, "Title"],
Cell[1827, 55, 82, 5, 78, "Text"],

Cell[CellGroupData[{
Cell[1934, 64, 38, 0, 69, "Section"],
Cell[1975, 66, 66, 0, 30, "Text"],
Cell[2044, 68, 301, 10, 39, "Text"],
Cell[2348, 80, 32, 0, 30, "Text"],
Cell[2383, 82, 298, 10, 39, "Text"],
Cell[2684, 94, 1331, 34, 156, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4052, 133, 23, 0, 69, "Section"],
Cell[4078, 135, 300, 9, 66, "Text"],
Cell[4381, 146, 41, 1, 27, "Input"],
Cell[4425, 149, 262, 5, 62, "Text"],
Cell[4690, 156, 330, 5, 39, "Text"],
Cell[5023, 163, 1155, 26, 136, "Text"],

Cell[CellGroupData[{
Cell[6203, 193, 237, 4, 75, "Input"],
Cell[6443, 199, 278, 4, 36, "Message"],
Cell[6724, 205, 311, 5, 35, "Message"],
Cell[7038, 212, 278, 4, 36, "Message"],
Cell[7319, 218, 311, 5, 35, "Message"],
Cell[7633, 225, 278, 4, 36, "Message"],
Cell[7914, 231, 329, 5, 35, "Message"],
Cell[8246, 238, 311, 5, 35, "Message"],
Cell[8560, 245, 336, 5, 35, "Message"],
Cell[8899, 252, 383, 6, 45, "Output"]
}, Open  ]],
Cell[9297, 261, 572, 12, 103, "Text"],

Cell[CellGroupData[{
Cell[9894, 277, 92, 1, 27, "Input"],
Cell[9989, 280, 106, 2, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10144, 288, 75, 1, 71, "Section"],
Cell[10222, 291, 1893, 56, 137, "Text"],
Cell[12118, 349, 400, 9, 105, "Input"],
Cell[12521, 360, 47, 0, 30, "Text"],
Cell[12571, 362, 72, 1, 42, "Input"],
Cell[12646, 365, 100, 3, 30, "Text"],

Cell[CellGroupData[{
Cell[12771, 372, 93, 1, 27, "Input"],
Cell[12867, 375, 278, 4, 36, "Message"],
Cell[13148, 381, 311, 5, 35, "Message"],
Cell[13462, 388, 278, 4, 36, "Message"],
Cell[13743, 394, 311, 5, 35, "Message"],
Cell[14057, 401, 355, 5, 35, "Message"]
}, Open  ]],
Cell[14427, 409, 646, 15, 83, "Text"],

Cell[CellGroupData[{
Cell[15098, 428, 562, 9, 234, "Input"],
Cell[15663, 439, 41303, 1359, 186, 15703, 1038, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[56981, 1801, 1281, 29, 208, "Text"],

Cell[CellGroupData[{
Cell[58287, 1834, 155, 4, 75, "Input"],
Cell[58445, 1840, 79, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58573, 1847, 40, 0, 69, "Section"],
Cell[58616, 1849, 1982, 44, 326, "Text"],

Cell[CellGroupData[{
Cell[60623, 1897, 246, 4, 75, "Input"],
Cell[60872, 1903, 278, 4, 36, "Message"],
Cell[61153, 1909, 311, 5, 35, "Message"],
Cell[61467, 1916, 278, 4, 36, "Message"],
Cell[61748, 1922, 311, 5, 35, "Message"]
}, Open  ]],
Cell[62074, 1930, 605, 10, 126, "Text"],
Cell[62682, 1942, 403, 7, 135, "Input"],
Cell[63088, 1951, 151, 3, 46, "Text"],

Cell[CellGroupData[{
Cell[63264, 1958, 691, 14, 231, "Input"],
Cell[63958, 1974, 33195, 1008, 186, 11404, 735, "GraphicsData", "PostScript", \
"Graphics"],
Cell[97156, 2984, 135, 2, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97340, 2992, 31, 0, 69, "Section"],
Cell[97374, 2994, 257, 5, 62, "Text"],
Cell[97634, 3001, 166, 4, 46, "Text"],
Cell[97803, 3007, 186, 4, 46, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

